/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Peer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class Peers {
    public final ArrayList<Peer> peers;
    public final HashMap<String, Node> nodes;
    public final HashSet<Node> removeNodes;
    private final HashSet<Host> invalidHosts;
    public int refreshCount;
    public boolean genChanged;

    public Peers(int peerCapacity) {
        this.peers = new ArrayList(peerCapacity);
        this.nodes = new HashMap(16);
        this.removeNodes = new HashSet(8);
        this.invalidHosts = new HashSet(8);
    }

    public boolean hasFailed(Host host) {
        return this.invalidHosts.contains(host);
    }

    public void fail(Host host) {
        this.invalidHosts.add(host);
    }

    public int getInvalidCount() {
        return this.invalidHosts.size();
    }

    public void clusterInitError() {
        StringBuilder sb = new StringBuilder();
        sb.append("Peers not reachable: ");
        boolean comma = false;
        for (Host host : this.invalidHosts) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(host);
        }
        throw new AerospikeException(sb.toString());
    }
}

