/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncReadCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public final class ExistsCommand
extends SyncReadCommand {
    private boolean exists;

    public ExistsCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, policy, key);
    }

    @Override
    protected void writeBuffer() {
        this.setExists(this.policy, this.key);
    }

    @Override
    protected void parseResult(Node node, Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        rp.parseFields(this.policy.txn, this.key, false);
        if (node.areMetricsEnabled()) {
            node.addBytesIn(this.namespace, rp.bytesIn);
        }
        if (rp.resultCode == 0) {
            this.exists = true;
            return;
        }
        if (rp.resultCode == 2) {
            this.exists = false;
            return;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            this.exists = true;
            return;
        }
        throw new AerospikeException(rp.resultCode);
    }

    public boolean exists() {
        return this.exists;
    }
}

