/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.BatchRecord;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Txn;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.ListOperation;
import com.aerospike.client.cdt.ListOrder;
import com.aerospike.client.cdt.ListPolicy;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.TxnAddKeys;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.List;

public final class TxnMonitor {
    private static final ListPolicy OrderedListPolicy = new ListPolicy(ListOrder.ORDERED, 13);
    private static final String BinNameId = "id";
    private static final String BinNameDigests = "keyds";

    public static void addKey(Cluster cluster, WritePolicy policy, Key cmdKey) {
        Txn txn = policy.txn;
        txn.verifyCommand();
        if (txn.getWrites().contains(cmdKey)) {
            return;
        }
        Operation[] ops = TxnMonitor.getTranOps(txn, cmdKey);
        TxnMonitor.addWriteKeys(cluster, policy, ops);
    }

    public static void addKeys(Cluster cluster, BatchPolicy policy, Key[] keys) {
        Operation[] ops = TxnMonitor.getTranOps(policy.txn, keys);
        TxnMonitor.addWriteKeys(cluster, policy, ops);
    }

    public static void addKeys(Cluster cluster, BatchPolicy policy, List<BatchRecord> records) {
        Operation[] ops = TxnMonitor.getTranOps(policy.txn, records);
        if (ops != null) {
            TxnMonitor.addWriteKeys(cluster, policy, ops);
        }
    }

    public static Operation[] getTranOps(Txn txn, Key cmdKey) {
        txn.setNamespace(cmdKey.namespace);
        if (txn.monitorExists()) {
            return new Operation[]{ListOperation.append(OrderedListPolicy, BinNameDigests, Value.get(cmdKey.digest), new CTX[0])};
        }
        return new Operation[]{Operation.put(new Bin(BinNameId, txn.getId())), ListOperation.append(OrderedListPolicy, BinNameDigests, Value.get(cmdKey.digest), new CTX[0])};
    }

    public static Operation[] getTranOps(Txn txn, Key[] keys) {
        txn.verifyCommand();
        ArrayList<Value> list = new ArrayList<Value>(keys.length);
        for (Key key : keys) {
            txn.setNamespace(key.namespace);
            list.add(Value.get(key.digest));
        }
        return TxnMonitor.getTranOps(txn, list);
    }

    public static Operation[] getTranOps(Txn txn, List<BatchRecord> records) {
        txn.verifyCommand();
        ArrayList<Value> list = new ArrayList<Value>(records.size());
        for (BatchRecord br : records) {
            txn.setNamespace(br.key.namespace);
            if (!br.hasWrite) continue;
            list.add(Value.get(br.key.digest));
        }
        if (list.size() == 0) {
            return null;
        }
        return TxnMonitor.getTranOps(txn, list);
    }

    private static Operation[] getTranOps(Txn txn, ArrayList<Value> list) {
        if (txn.monitorExists()) {
            return new Operation[]{ListOperation.appendItems(OrderedListPolicy, BinNameDigests, list, new CTX[0])};
        }
        return new Operation[]{Operation.put(new Bin(BinNameId, txn.getId())), ListOperation.appendItems(OrderedListPolicy, BinNameDigests, list, new CTX[0])};
    }

    private static void addWriteKeys(Cluster cluster, Policy policy, Operation[] ops) {
        Txn txn = policy.txn;
        Key txnKey = TxnMonitor.getTxnMonitorKey(txn);
        WritePolicy wp = TxnMonitor.copyTimeoutPolicy(policy);
        OperateArgs args = new OperateArgs(wp, null, null, ops);
        TxnAddKeys cmd = new TxnAddKeys(cluster, txnKey, args, txn);
        cmd.execute();
    }

    public static Key getTxnMonitorKey(Txn txn) {
        return new Key(txn.getNamespace(), "<ERO~MRT", txn.getId());
    }

    public static WritePolicy copyTimeoutPolicy(Policy policy) {
        WritePolicy wp = new WritePolicy();
        wp.connectTimeout = policy.connectTimeout;
        wp.socketTimeout = policy.socketTimeout;
        wp.totalTimeout = policy.totalTimeout;
        wp.timeoutDelay = policy.timeoutDelay;
        wp.maxRetries = policy.maxRetries;
        wp.sleepBetweenRetries = policy.sleepBetweenRetries;
        wp.compress = policy.compress;
        wp.respondAllOps = true;
        wp.expiration = policy.txn.getTimeout();
        return wp;
    }
}

