/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.configuration;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.ConfigurationTypeDescription;
import com.aerospike.client.configuration.serializers.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfigProvider
implements ConfigurationProvider {
    private static final String CONFIG_PATH_ENV = "AEROSPIKE_CLIENT_CONFIG_URL";
    private static final String CONFIG_PATH_SYS_PROP = "AEROSPIKE_CLIENT_CONFIG_SYS_PROP";
    private static final String YAML_SERIALIZERS_PATH = "com.aerospike.client.configuration.serializers.";
    private static final String DEFAULT_CONFIG_URL_PREFIX = "file://";
    private static final List<String> SUPPORTED_SCHEMA_VERSIONS = Collections.singletonList("1.0.0");
    private String path;
    private Configuration configuration;
    private long lastModified;

    public static List<String> getSupportedVersions() {
        return SUPPORTED_SCHEMA_VERSIONS;
    }

    public static String getConfigPath() {
        String configPath = System.getenv(CONFIG_PATH_ENV);
        if (configPath == null) {
            configPath = System.getProperty(CONFIG_PATH_SYS_PROP);
        }
        return configPath;
    }

    public static YamlConfigProvider getConfigProvider(String configPath) {
        try {
            return new YamlConfigProvider(configPath);
        }
        catch (Exception e) {
            if (Log.warnEnabled()) {
                Log.warn(e.getMessage());
            }
            return null;
        }
    }

    public YamlConfigProvider(String configPath) {
        if (Log.debugEnabled()) {
            Log.debug("Supported YAML config schema versions: " + YamlConfigProvider.getSupportedVersions());
        }
        try {
            if (!configPath.startsWith(DEFAULT_CONFIG_URL_PREFIX)) {
                configPath = DEFAULT_CONFIG_URL_PREFIX + configPath;
            }
            URI envURI = new URI(configPath);
            this.path = Paths.get(envURI).toString();
            this.loadConfiguration();
        }
        catch (Throwable t) {
            throw new AerospikeException("Failed to parse " + configPath + ": " + t);
        }
    }

    @Override
    public Configuration fetchConfiguration() {
        return this.configuration;
    }

    @Override
    public Configuration fetchDynamicConfiguration() {
        if (this.configuration.staticConfiguration != null) {
            this.configuration.staticConfiguration = null;
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadConfiguration() {
        FileInputStream fileInputStream;
        File file = new File(this.path);
        if (!file.exists()) {
            throw new AerospikeException("File does not exist: " + this.path);
        }
        long newLastModified = file.lastModified();
        if (newLastModified == this.lastModified) {
            return false;
        }
        ConfigurationTypeDescription configurationTypeDescription = new ConfigurationTypeDescription();
        LoaderOptions yamlLoaderOptions = new LoaderOptions();
        Map<Class<?>, TypeDescription> typeDescriptions = configurationTypeDescription.buildTypeDescriptions(YAML_SERIALIZERS_PATH, Configuration.class);
        Constructor typeDescriptionConstructor = new Constructor(Configuration.class, yamlLoaderOptions);
        typeDescriptions.values().forEach(arg_0 -> ((Constructor)typeDescriptionConstructor).addTypeDescription(arg_0));
        DumperOptions dumperOptions = new DumperOptions();
        Representer representer = new Representer(dumperOptions);
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml((BaseConstructor)typeDescriptionConstructor, representer, dumperOptions);
        try {
            fileInputStream = new FileInputStream(this.path);
        }
        catch (FileNotFoundException e) {
            throw new AerospikeException(e);
        }
        try {
            this.configuration = (Configuration)yaml.load((InputStream)fileInputStream);
            this.lastModified = newLastModified;
            if (this.configuration.getVersion() == null) {
                throw new AerospikeException("YAML config must contain a valid version field.");
            }
            if (Log.debugEnabled()) {
                Log.debug("YAML config successfully loaded.");
            }
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return true;
    }
}

