/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicBatchDeleteConfig;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.GenerationPolicy;

public final class BatchDeletePolicy {
    public Expression filterExp;
    public CommitLevel commitLevel = CommitLevel.COMMIT_ALL;
    public GenerationPolicy generationPolicy = GenerationPolicy.NONE;
    public int generation;
    public boolean durableDelete;
    public boolean sendKey;

    public BatchDeletePolicy(BatchDeletePolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false);
    }

    public BatchDeletePolicy(BatchDeletePolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public BatchDeletePolicy(BatchDeletePolicy other) {
        this.filterExp = other.filterExp;
        this.commitLevel = other.commitLevel;
        this.generationPolicy = other.generationPolicy;
        this.generation = other.generation;
        this.durableDelete = other.durableDelete;
        this.sendKey = other.sendKey;
    }

    public BatchDeletePolicy() {
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicBatchDeleteConfig dynBDC = dConfig.getDynamicBatchDeleteConfig();
        if (dynBDC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynBDC.sendKey != null && this.sendKey != dynBDC.sendKey.value) {
            this.sendKey = dynBDC.sendKey.value;
            if (logUpdate) {
                Log.info("Set BatchDeletePolicy.sendKey = " + this.sendKey);
            }
        }
        if (dynBDC.durableDelete != null && this.durableDelete != dynBDC.durableDelete.value) {
            this.durableDelete = dynBDC.durableDelete.value;
            if (logUpdate) {
                Log.info("Set BatchDeletePolicy.durableDelete = " + this.durableDelete);
            }
        }
    }

    public void setFilterExp(Expression filterExp) {
        this.filterExp = filterExp;
    }

    public void setCommitLevel(CommitLevel commitLevel) {
        this.commitLevel = commitLevel;
    }

    public void setGenerationPolicy(GenerationPolicy generationPolicy) {
        this.generationPolicy = generationPolicy;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public void setDurableDelete(boolean durableDelete) {
        this.durableDelete = durableDelete;
    }

    public void setSendKey(boolean sendKey) {
        this.sendKey = sendKey;
    }
}

