/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicBatchUDFconfig;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.CommitLevel;

public final class BatchUDFPolicy {
    public Expression filterExp;
    public CommitLevel commitLevel = CommitLevel.COMMIT_ALL;
    public int expiration;
    public boolean durableDelete;
    public boolean onLockingOnly;
    public boolean sendKey;

    public BatchUDFPolicy(BatchUDFPolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false);
    }

    public BatchUDFPolicy(BatchUDFPolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public BatchUDFPolicy(BatchUDFPolicy other) {
        this.filterExp = other.filterExp;
        this.commitLevel = other.commitLevel;
        this.expiration = other.expiration;
        this.durableDelete = other.durableDelete;
        this.onLockingOnly = other.onLockingOnly;
        this.sendKey = other.sendKey;
    }

    public BatchUDFPolicy() {
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicBatchUDFconfig dynUDF = dConfig.getDynamicBatchUDFconfig();
        if (dynUDF == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynUDF.sendKey != null && this.sendKey != dynUDF.sendKey.value) {
            this.sendKey = dynUDF.sendKey.value;
            if (logUpdate) {
                Log.info("Set BatchUDFPolicy.sendKey = " + this.sendKey);
            }
        }
        if (dynUDF.durableDelete != null && this.durableDelete != dynUDF.durableDelete.value) {
            this.durableDelete = dynUDF.durableDelete.value;
            if (logUpdate) {
                Log.info("Set BatchUDFPolicy.sendKey = " + this.sendKey);
            }
        }
    }

    public void setFilterExp(Expression filterExp) {
        this.filterExp = filterExp;
    }

    public void setCommitLevel(CommitLevel commitLevel) {
        this.commitLevel = commitLevel;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setDurableDelete(boolean durableDelete) {
        this.durableDelete = durableDelete;
    }

    public void setOnLockingOnly(boolean onLockingOnly) {
        this.onLockingOnly = onLockingOnly;
    }

    public void setSendKey(boolean sendKey) {
        this.sendKey = sendKey;
    }
}

