/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicQueryConfig;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryDuration;

public class QueryPolicy
extends Policy {
    public QueryDuration expectedDuration;
    @Deprecated
    public long maxRecords;
    public int maxConcurrentNodes;
    public int recordQueueSize = 5000;
    public int infoTimeout = 1000;
    public boolean includeBinData = true;
    public boolean failOnClusterChange;
    @Deprecated
    public boolean shortQuery;

    public QueryPolicy(QueryPolicy other, ConfigurationProvider configProvider) {
        this(other);
        this.updateFromConfig(configProvider, false);
    }

    public QueryPolicy(QueryPolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        this(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public QueryPolicy(QueryPolicy other) {
        super(other);
        this.expectedDuration = other.expectedDuration;
        this.maxRecords = other.maxRecords;
        this.maxConcurrentNodes = other.maxConcurrentNodes;
        this.recordQueueSize = other.recordQueueSize;
        this.infoTimeout = other.infoTimeout;
        this.includeBinData = other.includeBinData;
        this.failOnClusterChange = other.failOnClusterChange;
        this.shortQuery = other.shortQuery;
    }

    public QueryPolicy(Policy other) {
        super(other);
    }

    public QueryPolicy() {
        this.totalTimeout = 0;
        this.maxRetries = 5;
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicQueryConfig dynQC = dConfig.getDynamicQueryConfig();
        if (dynQC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynQC.connectTimeout != null && this.connectTimeout != dynQC.connectTimeout.value) {
            this.connectTimeout = dynQC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynQC.replica != null && this.replica != dynQC.replica) {
            this.replica = dynQC.replica;
            if (logUpdate) {
                Log.info("Set QueryPolicy.replica = " + (Object)((Object)this.replica));
            }
        }
        if (dynQC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynQC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynQC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynQC.socketTimeout != null && this.socketTimeout != dynQC.socketTimeout.value) {
            this.socketTimeout = dynQC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynQC.timeoutDelay != null && this.timeoutDelay != dynQC.timeoutDelay.value) {
            this.timeoutDelay = dynQC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynQC.totalTimeout != null && this.totalTimeout != dynQC.totalTimeout.value) {
            this.totalTimeout = dynQC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynQC.maxRetries != null && this.maxRetries != dynQC.maxRetries.value) {
            this.maxRetries = dynQC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.maxRetries = " + this.maxRetries);
            }
        }
        if (dynQC.includeBinData != null && this.includeBinData != dynQC.includeBinData.value) {
            this.includeBinData = dynQC.includeBinData.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.includeBinData = " + this.includeBinData);
            }
        }
        if (dynQC.infoTimeout != null && this.infoTimeout != dynQC.infoTimeout.value) {
            this.infoTimeout = dynQC.infoTimeout.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.infoTimeout = " + this.infoTimeout);
            }
        }
        if (dynQC.recordQueueSize != null && this.recordQueueSize != dynQC.recordQueueSize.value) {
            this.recordQueueSize = dynQC.recordQueueSize.value;
            if (logUpdate) {
                Log.info("Set QueryPolicy.recordQueueSize = " + this.recordQueueSize);
            }
        }
        if (dynQC.expectedDuration != null && this.expectedDuration != dynQC.expectedDuration) {
            this.expectedDuration = dynQC.expectedDuration;
            if (logUpdate) {
                Log.info("Set QueryPolicy.expectedDuration = " + (Object)((Object)this.expectedDuration));
            }
        }
    }

    public void setExpectedDuration(QueryDuration expectedDuration) {
        this.expectedDuration = expectedDuration;
    }

    public void setMaxRecords(long maxRecords) {
        this.maxRecords = maxRecords;
    }

    public void setMaxConcurrentNodes(int maxConcurrentNodes) {
        this.maxConcurrentNodes = maxConcurrentNodes;
    }

    public void setRecordQueueSize(int recordQueueSize) {
        this.recordQueueSize = recordQueueSize;
    }

    public void setInfoTimeout(int infoTimeout) {
        this.infoTimeout = infoTimeout;
    }

    public void setIncludeBinData(boolean includeBinData) {
        this.includeBinData = includeBinData;
    }

    public void setFailOnClusterChange(boolean failOnClusterChange) {
        this.failOnClusterChange = failOnClusterChange;
    }

    public void setShortQuery(boolean shortQuery) {
        this.shortQuery = shortQuery;
    }
}

