/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicTxnRollConfig;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Replica;

public class TxnRollPolicy
extends BatchPolicy {
    public TxnRollPolicy(TxnRollPolicy other) {
        super(other);
    }

    public TxnRollPolicy(TxnRollPolicy other, ConfigurationProvider configProvider) {
        super(other);
        this.updateFromConfig(configProvider, false);
    }

    public TxnRollPolicy(TxnRollPolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        super(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public TxnRollPolicy() {
        this.replica = Replica.MASTER;
        this.maxRetries = 5;
        this.socketTimeout = 3000;
        this.totalTimeout = 10000;
        this.sleepBetweenRetries = 1000;
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicTxnRollConfig dynTRC = dConfig.getDynamicTxnRollConfig();
        if (dynTRC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynTRC.readModeAP != null & this.readModeAP != dynTRC.readModeAP) {
            this.readModeAP = dynTRC.readModeAP;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.readModeAP = " + (Object)((Object)this.readModeAP));
            }
        }
        if (dynTRC.readModeSC != null && this.readModeSC != dynTRC.readModeSC) {
            this.readModeSC = dynTRC.readModeSC;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.readModeSC = " + (Object)((Object)this.readModeSC));
            }
        }
        if (dynTRC.connectTimeout != null && this.connectTimeout != dynTRC.connectTimeout.value) {
            this.connectTimeout = dynTRC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynTRC.replica != null && this.replica != dynTRC.replica) {
            this.replica = dynTRC.replica;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.replica = " + (Object)((Object)this.replica));
            }
        }
        if (dynTRC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynTRC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynTRC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynTRC.socketTimeout != null && this.socketTimeout != dynTRC.socketTimeout.value) {
            this.socketTimeout = dynTRC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynTRC.timeoutDelay != null && this.timeoutDelay != dynTRC.timeoutDelay.value) {
            this.timeoutDelay = dynTRC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynTRC.totalTimeout != null && this.totalTimeout != dynTRC.totalTimeout.value) {
            this.totalTimeout = dynTRC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynTRC.maxRetries != null && this.maxRetries != dynTRC.maxRetries.value) {
            this.maxRetries = dynTRC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.maxRetries = " + this.maxRetries);
            }
        }
        if (dynTRC.maxConcurrentThreads != null && this.maxConcurrentThreads != dynTRC.maxConcurrentThreads.value) {
            this.maxConcurrentThreads = dynTRC.maxConcurrentThreads.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.maxConcurrentThreads = " + this.maxConcurrentThreads);
            }
        }
        if (dynTRC.allowInline != null && this.allowInline != dynTRC.allowInline.value) {
            this.allowInline = dynTRC.allowInline.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.allowInline = " + this.allowInline);
            }
        }
        if (dynTRC.allowInlineSSD != null && this.allowInlineSSD != dynTRC.allowInlineSSD.value) {
            this.allowInlineSSD = dynTRC.allowInlineSSD.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.allowInlineSSD = " + this.allowInlineSSD);
            }
        }
        if (dynTRC.respondAllKeys != null && this.respondAllKeys != dynTRC.respondAllKeys.value) {
            this.respondAllKeys = dynTRC.respondAllKeys.value;
            if (logUpdate) {
                Log.info("Set TxnRollPolicy.respondAllKeys = " + this.respondAllKeys);
            }
        }
    }
}

