/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Log;
import com.aerospike.client.configuration.ConfigurationProvider;
import com.aerospike.client.configuration.serializers.Configuration;
import com.aerospike.client.configuration.serializers.DynamicConfiguration;
import com.aerospike.client.configuration.serializers.dynamicconfig.DynamicTxnVerifyConfig;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;

public class TxnVerifyPolicy
extends BatchPolicy {
    public TxnVerifyPolicy(TxnVerifyPolicy other) {
        super(other);
    }

    public TxnVerifyPolicy(TxnVerifyPolicy other, ConfigurationProvider configProvider) {
        super(other);
        this.updateFromConfig(configProvider, false);
    }

    public TxnVerifyPolicy(TxnVerifyPolicy other, ConfigurationProvider configProvider, boolean isDefaultPolicy) {
        super(other);
        this.updateFromConfig(configProvider, isDefaultPolicy);
    }

    public TxnVerifyPolicy() {
        this.readModeSC = ReadModeSC.LINEARIZE;
        this.replica = Replica.MASTER;
        this.maxRetries = 5;
        this.socketTimeout = 3000;
        this.totalTimeout = 10000;
        this.sleepBetweenRetries = 1000;
    }

    private void updateFromConfig(ConfigurationProvider configProvider, boolean log2) {
        boolean logUpdate = false;
        if (configProvider == null) {
            return;
        }
        Configuration config = configProvider.fetchConfiguration();
        if (config == null) {
            return;
        }
        DynamicConfiguration dConfig = config.getDynamicConfiguration();
        if (dConfig == null) {
            return;
        }
        DynamicTxnVerifyConfig dynTVC = dConfig.getDynamicTxnVerifyConfig();
        if (dynTVC == null) {
            return;
        }
        if (log2 && Log.infoEnabled()) {
            logUpdate = true;
        }
        if (dynTVC.readModeAP != null & this.readModeAP != dynTVC.readModeAP) {
            this.readModeAP = dynTVC.readModeAP;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.readModeAP = " + (Object)((Object)this.readModeAP));
            }
        }
        if (dynTVC.readModeSC != null && this.readModeSC != dynTVC.readModeSC) {
            this.readModeSC = dynTVC.readModeSC;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.readModeSC = " + (Object)((Object)this.readModeSC));
            }
        }
        if (dynTVC.connectTimeout != null && this.connectTimeout != dynTVC.connectTimeout.value) {
            this.connectTimeout = dynTVC.connectTimeout.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.connectTimeout = " + this.connectTimeout);
            }
        }
        if (dynTVC.replica != null && this.replica != dynTVC.replica) {
            this.replica = dynTVC.replica;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.replica = " + (Object)((Object)this.replica));
            }
        }
        if (dynTVC.sleepBetweenRetries != null && this.sleepBetweenRetries != dynTVC.sleepBetweenRetries.value) {
            this.sleepBetweenRetries = dynTVC.sleepBetweenRetries.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.sleepBetweenRetries = " + this.sleepBetweenRetries);
            }
        }
        if (dynTVC.socketTimeout != null && this.socketTimeout != dynTVC.socketTimeout.value) {
            this.socketTimeout = dynTVC.socketTimeout.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.socketTimeout = " + this.socketTimeout);
            }
        }
        if (dynTVC.timeoutDelay != null && this.timeoutDelay != dynTVC.timeoutDelay.value) {
            this.timeoutDelay = dynTVC.timeoutDelay.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.timeoutDelay = " + this.timeoutDelay);
            }
        }
        if (dynTVC.totalTimeout != null && this.totalTimeout != dynTVC.totalTimeout.value) {
            this.totalTimeout = dynTVC.totalTimeout.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.totalTimeout = " + this.totalTimeout);
            }
        }
        if (dynTVC.maxRetries != null && this.maxRetries != dynTVC.maxRetries.value) {
            this.maxRetries = dynTVC.maxRetries.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.maxRetries = " + this.maxRetries);
            }
        }
        if (dynTVC.maxConcurrentThreads != null && this.maxConcurrentThreads != dynTVC.maxConcurrentThreads.value) {
            this.maxConcurrentThreads = dynTVC.maxConcurrentThreads.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.maxConcurrentThreads = " + this.maxConcurrentThreads);
            }
        }
        if (dynTVC.allowInline != null && this.allowInline != dynTVC.allowInline.value) {
            this.allowInline = dynTVC.allowInline.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.allowInline = " + this.allowInline);
            }
        }
        if (dynTVC.allowInlineSSD != null && this.allowInlineSSD != dynTVC.allowInlineSSD.value) {
            this.allowInlineSSD = dynTVC.allowInlineSSD.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.allowInlineSSD = " + this.allowInlineSSD);
            }
        }
        if (dynTVC.respondAllKeys != null && this.respondAllKeys != dynTVC.respondAllKeys.value) {
            this.respondAllKeys = dynTVC.respondAllKeys.value;
            if (logUpdate) {
                Log.info("Set TxnVerifyPolicy.respondAllKeys = " + this.respondAllKeys);
            }
        }
    }
}

