/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.Task;
import com.aerospike.client.util.Version;

public class ExecuteTask
extends Task {
    private final long taskId;
    private final boolean scan;

    public ExecuteTask(Cluster cluster, Policy policy, Statement statement, long taskId) {
        this(cluster, policy, taskId, statement.isScan());
    }

    public ExecuteTask(Cluster cluster, Policy policy, long taskId, boolean isScan) {
        super(cluster, policy);
        this.taskId = taskId;
        this.scan = isScan;
    }

    protected ExecuteTask(long taskId, boolean isScan) {
        super(null, new Policy());
        this.taskId = taskId;
        this.scan = isScan;
    }

    public long getTaskId() {
        return this.taskId;
    }

    @Override
    public int queryStatus() throws AerospikeException {
        Node[] nodes = this.cluster.validateNodes();
        String tid = Long.toUnsignedString(this.taskId);
        String module = this.scan ? "scan" : "query";
        for (Node node : nodes) {
            int end;
            String cmd3;
            Version serverVersion = node.getVersion();
            String cmd1 = serverVersion.isGreaterOrEqual(Version.SERVER_VERSION_8_1) ? "query-show:id=" + tid : "query-show:trid=" + tid;
            String cmd2 = serverVersion.isGreaterOrEqual(Version.SERVER_VERSION_8_1) ? module + "-show:id=" + tid : module + "-show:trid=" + tid;
            String string = cmd3 = serverVersion.isGreaterOrEqual(Version.SERVER_VERSION_8_1) ? "jobs:module=" + module + ";cmd=get-job;id=" + tid : "jobs:module=" + module + ";cmd=get-job;trid=" + tid;
            String command = node.hasPartitionQuery() ? cmd1 : (node.hasQueryShow() ? cmd2 : cmd3);
            String response = Info.request(this.policy, node, command);
            if (response.startsWith("ERROR:2")) {
                if (node.hasPartitionQuery()) continue;
                return 0;
            }
            if (response.startsWith("ERROR:")) {
                throw new AerospikeException(command + " failed: " + response);
            }
            String find = "status=";
            int index2 = response.indexOf(find);
            if (index2 < 0) {
                throw new AerospikeException(command + " failed: " + response);
            }
            int begin = index2 + find.length();
            String status = response.substring(begin, end = response.indexOf(58, begin));
            if (status.startsWith("done") || status.startsWith("DONE")) continue;
            return 1;
        }
        return 2;
    }
}

