/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class Util {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getErrorMessage(Throwable e) {
        Throwable cause = e.getCause();
        if (e instanceof SocketException || e instanceof AerospikeException.Connection || cause instanceof SocketTimeoutException) {
            return e.getMessage();
        }
        if (e instanceof EOFException || cause instanceof EOFException) {
            return EOFException.class.getName();
        }
        return Util.getStackTrace(e);
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter(1000);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(File file) {
        try {
            byte[] bytes = new byte[(int)file.length()];
            try (FileInputStream in = new FileInputStream(file);){
                int len = 0;
                for (int pos = 0; pos < bytes.length; pos += len) {
                    len = in.read(bytes, pos, bytes.length - pos);
                }
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (Throwable e) {
            throw new AerospikeException("Failed to read " + file.getAbsolutePath(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readResource(ClassLoader resourceLoader, String resourcePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BigInteger[] toBigIntegerArray(String str) {
        String[] strArray = str.split(",");
        BigInteger[] bigArray = new BigInteger[strArray.length];
        int count = 0;
        for (String s : strArray) {
            if (s.startsWith("0x")) {
                bigArray[count] = new BigInteger(s.substring(2), 16);
            } else if (s.indexOf(58) >= 0) {
                s = s.replaceAll(":", "");
                bigArray[count] = new BigInteger(s, 16);
            } else {
                bigArray[count] = new BigInteger(s);
            }
            ++count;
        }
        return bigArray;
    }

    public static long toTimeStamp(String dateTime, SimpleDateFormat format, int timeZoneOffset) throws ParseException {
        Date formatDate = format.parse(dateTime);
        long miliSecondForDate = formatDate.getTime() - (long)timeZoneOffset;
        return miliSecondForDate / 1000L;
    }

    public static long toTimeStamp(String dateTime, String pattern, int timeZoneOffset) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return Util.toTimeStamp(dateTime, format, timeZoneOffset);
    }

    public static String fromTimeStamp(long timeStamp, SimpleDateFormat format) {
        Date formatDate = new Date(timeStamp);
        return format.format(formatDate);
    }

    public static String fromTimeStamp(long timeStamp, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return Util.fromTimeStamp(timeStamp, format);
    }

    public static long toLong(Object obj) {
        return obj != null ? (Long)obj : 0L;
    }

    public static int toInt(Object obj) {
        return (int)Util.toLong(obj);
    }

    public static short toShort(Object obj) {
        return (short)Util.toLong(obj);
    }

    public static byte toByte(Object obj) {
        return (byte)Util.toLong(obj);
    }

    public static boolean toBoolean(Object obj) {
        return Util.toLong(obj) != 0L;
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return 0.0;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return 0.0;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    public static boolean rackIdsEqual(List<Integer> racks1, int[] racks2) {
        if (racks1 == null) {
            return racks2 == null;
        }
        if (racks2 == null) {
            return false;
        }
        if (racks1.size() != racks2.length) {
            return false;
        }
        for (int i = 0; i < racks2.length; ++i) {
            int r2;
            int r1 = racks1.get(i);
            if (r1 == (r2 = racks2[i])) continue;
            return false;
        }
        return true;
    }
}

