/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.ResultCode;

public class AerospikeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int resultCode;

    public AerospikeException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, Exception e) {
        super(e);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode) {
        this.resultCode = resultCode;
    }

    public AerospikeException(String message, Exception e) {
        super(message, e);
    }

    public AerospikeException(String message) {
        super(message);
    }

    public AerospikeException(Throwable e) {
        super(e);
    }

    public AerospikeException() {
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String message = super.getMessage();
        if (this.resultCode != 0) {
            sb.append("Error Code ");
            sb.append(this.resultCode);
            sb.append(": ");
            if (message != null) {
                sb.append(message);
            } else {
                sb.append(ResultCode.getResultString(this.resultCode));
            }
        } else if (message != null) {
            sb.append(message);
        } else {
            sb.append(this.getClass().getName());
        }
        return sb.toString();
    }

    public final boolean keepConnection() {
        return ResultCode.keepConnection(this.resultCode);
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public static final class CommandRejected
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public CommandRejected() {
            super(-6);
        }
    }

    public static final class QueryTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public QueryTerminated() {
            super(-5);
        }

        public QueryTerminated(Exception e) {
            super(-5, e);
        }
    }

    public static final class ScanTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public ScanTerminated() {
            super(-4);
        }

        public ScanTerminated(Exception e) {
            super(-4, e);
        }
    }

    public static final class InvalidNode
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNode() {
            super(-3);
        }
    }

    public static final class Connection
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Connection(String message) {
            super(11, message);
        }

        public Connection(Exception e) {
            super(11, e);
        }
    }

    public static final class Parse
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-2, message);
        }
    }

    public static final class Serialize
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Serialize(Exception e) {
            super(-1, e);
        }
    }

    public static final class Timeout
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public int timeout;
        public int iterations;
        public int failedNodes;
        public int failedConns;

        public Timeout() {
            super(9);
            this.timeout = -1;
        }

        public Timeout(int timeout, int iterations, int failedNodes, int failedConns) {
            super(9);
            this.timeout = timeout;
            this.iterations = iterations;
            this.failedNodes = failedNodes;
            this.failedConns = failedConns;
        }

        @Override
        public String getMessage() {
            if (this.timeout == -1) {
                return super.getMessage();
            }
            return "Client timeout: timeout=" + this.timeout + " iterations=" + this.iterations + " failedNodes=" + this.failedNodes + " failedConns=" + this.failedConns;
        }
    }
}

