/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.Value;
import java.util.List;
import java.util.Map;

public final class Bin {
    public final String name;
    public final Value value;

    public Bin(String name, String value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, byte[] value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, byte[] value, int offset, int length) {
        this.name = name;
        this.value = Value.get(value, offset, length);
    }

    public Bin(String name, int value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, long value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public Bin(String name, Object value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public static Bin asList(String name, List<?> value) {
        return new Bin(name, Value.getAsList(value));
    }

    public static Bin asMap(String name, Map<?, ?> value) {
        return new Bin(name, Value.getAsMap(value));
    }

    public static Bin asBlob(String name, Object value) {
        return new Bin(name, Value.getAsBlob(value));
    }

    public static Bin asNull(String name) {
        return new Bin(name, Value.getAsNull());
    }

    public String toString() {
        return this.name + ':' + this.value;
    }
}

