/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.util.ThreadLocalData;
import gnu.crypto.util.Base64;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public final class Info {
    private static final int DEFAULT_TIMEOUT = 1000;
    private byte[] buffer = ThreadLocalData.getBuffer();
    private int length;
    private int offset;

    public Info(Connection conn, String command) throws AerospikeException {
        if (command.length() * 2 + 9 > this.buffer.length) {
            this.offset = Buffer.estimateSizeUtf8(command) + 9;
            this.resizeBuffer(this.offset);
        }
        this.offset = 8;
        this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
        this.buffer[this.offset++] = 10;
        this.sendCommand(conn);
    }

    public Info(Connection conn, String ... commands) throws AerospikeException {
        this.offset = 8;
        for (String command : commands) {
            this.offset += command.length() * 2 + 1;
        }
        if (this.offset > this.buffer.length) {
            this.offset = 8;
            for (String command : commands) {
                this.offset += Buffer.estimateSizeUtf8(command) + 1;
            }
            this.resizeBuffer(this.offset);
        }
        this.offset = 8;
        for (String command : commands) {
            this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
            this.buffer[this.offset++] = 10;
        }
        this.sendCommand(conn);
    }

    public Info(Connection conn) throws AerospikeException {
        this.offset = 8;
        this.sendCommand(conn);
    }

    public NameValueParser getNameValueParser() {
        this.skipToValue();
        return new NameValueParser();
    }

    public String getValue() {
        this.skipToValue();
        return Buffer.utf8ToString(this.buffer, this.offset, this.length - this.offset - 1);
    }

    private void skipToValue() {
        while (this.offset < this.length) {
            byte b = this.buffer[this.offset];
            if (b == 9) {
                ++this.offset;
                break;
            }
            if (b == 10) break;
            ++this.offset;
        }
    }

    public static String request(Node node, String name) throws AerospikeException {
        Connection conn = node.getConnection(1000);
        try {
            String response = Info.request(conn, name);
            node.putConnection(conn);
            return response;
        }
        catch (RuntimeException re) {
            conn.close();
            throw re;
        }
    }

    public static String request(InfoPolicy policy, Node node, String name) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            String result = Info.request(conn, name);
            node.putConnection(conn);
            return result;
        }
        catch (RuntimeException re) {
            conn.close();
            throw re;
        }
    }

    public static Map<String, String> request(InfoPolicy policy, Node node, String ... names) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            HashMap<String, String> result = Info.request(conn, names);
            node.putConnection(conn);
            return result;
        }
        catch (RuntimeException re) {
            conn.close();
            throw re;
        }
    }

    public static Map<String, String> request(InfoPolicy policy, Node node) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            HashMap<String, String> result = Info.request(conn);
            node.putConnection(conn);
            return result;
        }
        catch (RuntimeException re) {
            conn.close();
            throw re;
        }
    }

    public static String request(String hostname, int port, String name) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port), name);
    }

    public static HashMap<String, String> request(String hostname, int port, String ... names) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port), names);
    }

    public static HashMap<String, String> request(String hostname, int port) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(InetSocketAddress socketAddress, String name) throws AerospikeException {
        Connection conn = new Connection(socketAddress, 1000);
        try {
            String string = Info.request(conn, name);
            return string;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> request(InetSocketAddress socketAddress, String ... names) throws AerospikeException {
        Connection conn = new Connection(socketAddress, 1000);
        try {
            HashMap<String, String> hashMap = Info.request(conn, names);
            return hashMap;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> request(InetSocketAddress socketAddress) throws AerospikeException {
        Connection conn = new Connection(socketAddress, 1000);
        try {
            HashMap<String, String> hashMap = Info.request(conn);
            return hashMap;
        }
        finally {
            conn.close();
        }
    }

    public static String request(Connection conn, String name) throws AerospikeException {
        Info info = new Info(conn, name);
        return info.parseSingleResponse(name);
    }

    public static HashMap<String, String> request(Connection conn, String ... names) throws AerospikeException {
        Info info = new Info(conn, names);
        return info.parseMultiResponse();
    }

    public static HashMap<String, String> request(Connection conn) throws AerospikeException {
        Info info = new Info(conn);
        return info.parseMultiResponse();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }

    private void sendCommand(Connection conn) throws AerospikeException {
        try {
            long size = (long)this.offset - 8L | 0x200000000000000L | 0x1000000000000L;
            Buffer.longToBytes(size, this.buffer, 0);
            conn.write(this.buffer, this.offset);
            conn.readFully(this.buffer, 8);
            size = Buffer.bytesToLong(this.buffer, 0);
            this.length = (int)(size & 0xFFFFFFFFFFFFL);
            this.resizeBuffer(this.length);
            conn.readFully(this.buffer, this.length);
            this.offset = 0;
        }
        catch (IOException ioe) {
            throw new AerospikeException(ioe);
        }
    }

    private void resizeBuffer(int size) {
        if (size > this.buffer.length) {
            this.buffer = ThreadLocalData.resizeBuffer(size);
        }
    }

    private String parseSingleResponse(String name) throws AerospikeException {
        String response = Buffer.utf8ToString(this.buffer, 0, this.length);
        if (response.startsWith(name)) {
            if (response.length() > name.length() + 1) {
                return response.substring(name.length() + 1, response.length() - 1);
            }
            return null;
        }
        throw new AerospikeException.Parse("Info response does not include: " + name);
    }

    private HashMap<String, String> parseMultiResponse() throws AerospikeException {
        HashMap<String, String> responses = new HashMap<String, String>();
        int offset = 0;
        int begin = 0;
        StringBuilder sb = new StringBuilder(this.length);
        while (offset < this.length) {
            String name;
            byte b = this.buffer[offset];
            if (b == 9) {
                name = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
                this.checkError(name);
                begin = ++offset;
                while (offset < this.length && this.buffer[offset] != 10) {
                    ++offset;
                }
                if (offset > begin) {
                    String value = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
                    responses.put(name, value);
                } else {
                    responses.put(name, null);
                }
                begin = ++offset;
                continue;
            }
            if (b == 10) {
                if (offset > begin) {
                    name = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
                    this.checkError(name);
                    responses.put(name, null);
                }
                begin = ++offset;
                continue;
            }
            ++offset;
        }
        if (offset > begin) {
            String name = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
            this.checkError(name);
            responses.put(name, null);
        }
        return responses;
    }

    private void checkError(String str) throws AerospikeException {
        if (str.startsWith("ERROR:")) {
            int begin = 6;
            int end = str.indexOf(58, begin);
            int code = -1;
            String message = "";
            if (end >= 0) {
                code = Integer.parseInt(str.substring(begin, end));
                message = str.charAt(str.length() - 1) == '\n' ? str.substring(end + 1, str.length() - 1) : str.substring(end + 1);
            }
            throw new AerospikeException(code, message);
        }
    }

    public class NameValueParser {
        private int nameBegin;
        private int nameEnd;
        private int valueBegin;
        private int valueEnd;

        public boolean next() {
            this.nameBegin = Info.this.offset;
            while (Info.this.offset < Info.this.length) {
                byte b = Info.this.buffer[Info.this.offset];
                if (b == 61) {
                    if (Info.this.offset <= this.nameBegin) {
                        return false;
                    }
                    this.nameEnd = Info.this.offset;
                    this.parseValue();
                    return true;
                }
                if (b == 10) break;
                Info.this.offset++;
            }
            this.nameEnd = Info.this.offset;
            this.valueBegin = Info.this.offset;
            this.valueEnd = Info.this.offset;
            return Info.this.offset > this.nameBegin;
        }

        private void parseValue() {
            this.valueBegin = ++Info.this.offset;
            while (Info.this.offset < Info.this.length) {
                byte b = Info.this.buffer[Info.this.offset];
                if (b == 59) {
                    this.valueEnd = Info.this.offset++;
                    return;
                }
                if (b == 10) break;
                Info.this.offset++;
            }
            this.valueEnd = Info.this.offset;
        }

        public String getName() {
            int len2 = this.nameEnd - this.nameBegin;
            return Buffer.utf8ToString(Info.this.buffer, this.nameBegin, len2);
        }

        public String getValue() {
            int len2 = this.valueEnd - this.valueBegin;
            if (len2 <= 0) {
                return null;
            }
            return Buffer.utf8ToString(Info.this.buffer, this.valueBegin, len2);
        }

        public String getStringBase64() {
            int len2 = this.valueEnd - this.valueBegin;
            if (len2 <= 0) {
                return null;
            }
            byte[] bytes = Base64.decode((byte[])Info.this.buffer, (int)this.valueBegin, (int)len2);
            return Buffer.utf8ToString(bytes, 0, bytes.length);
        }
    }
}

