/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.async.SelectorManager;
import com.aerospike.client.async.SelectorManagers;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeValidator;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class AsyncCluster
extends Cluster {
    private final BufferQueue bufferQueue;
    private final SelectorManagers selectorManagers;
    private final int maxCommands;

    public AsyncCluster(AsyncClientPolicy policy, Host[] hosts) throws AerospikeException {
        super(policy, hosts);
        this.maxCommands = policy.asyncMaxCommands;
        switch (policy.asyncMaxCommandAction) {
            case ACCEPT: {
                this.bufferQueue = new AcceptBufferQueue();
                break;
            }
            case REJECT: {
                this.bufferQueue = new RejectBufferQueue(this.maxCommands);
                break;
            }
            default: {
                this.bufferQueue = new BlockBufferQueue(this.maxCommands);
            }
        }
        this.selectorManagers = new SelectorManagers(policy);
        this.initTendThread(policy.failIfNotConnected);
    }

    @Override
    protected Node createNode(NodeValidator nv) {
        return new AsyncNode(this, nv);
    }

    public ByteBuffer getByteBuffer() throws AerospikeException {
        return this.bufferQueue.getByteBuffer();
    }

    public void putByteBuffer(ByteBuffer byteBuffer) {
        this.bufferQueue.putByteBuffer(byteBuffer);
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManagers.next();
    }

    public int getMaxCommands() {
        return this.maxCommands;
    }

    @Override
    public void close() {
        super.close();
        this.selectorManagers.close();
    }

    private static final class AcceptBufferQueue
    implements BufferQueue {
        private final ConcurrentLinkedQueue<ByteBuffer> bufferQueue = new ConcurrentLinkedQueue();

        private AcceptBufferQueue() {
        }

        @Override
        public ByteBuffer getByteBuffer() throws AerospikeException {
            ByteBuffer byteBuffer = this.bufferQueue.poll();
            if (byteBuffer == null) {
                return ByteBuffer.allocateDirect(8192);
            }
            return byteBuffer;
        }

        @Override
        public void putByteBuffer(ByteBuffer byteBuffer) {
            this.bufferQueue.offer(byteBuffer);
        }
    }

    private static final class RejectBufferQueue
    implements BufferQueue {
        private final ArrayBlockingQueue<ByteBuffer> bufferQueue;

        private RejectBufferQueue(int maxCommands) {
            this.bufferQueue = new ArrayBlockingQueue(maxCommands);
            for (int i = 0; i < maxCommands; ++i) {
                this.bufferQueue.add(ByteBuffer.allocateDirect(8192));
            }
        }

        @Override
        public ByteBuffer getByteBuffer() throws AerospikeException {
            ByteBuffer byteBuffer = this.bufferQueue.poll();
            if (byteBuffer == null) {
                throw new AerospikeException.CommandRejected();
            }
            return byteBuffer;
        }

        @Override
        public void putByteBuffer(ByteBuffer byteBuffer) {
            this.bufferQueue.offer(byteBuffer);
        }
    }

    private static final class BlockBufferQueue
    implements BufferQueue {
        private final ArrayBlockingQueue<ByteBuffer> bufferQueue;

        private BlockBufferQueue(int maxCommands) {
            this.bufferQueue = new ArrayBlockingQueue(maxCommands);
            for (int i = 0; i < maxCommands; ++i) {
                this.bufferQueue.add(ByteBuffer.allocateDirect(8192));
            }
        }

        @Override
        public ByteBuffer getByteBuffer() throws AerospikeException {
            try {
                return this.bufferQueue.take();
            }
            catch (InterruptedException ie) {
                throw new AerospikeException("Buffer pool take interrupted.");
            }
        }

        @Override
        public void putByteBuffer(ByteBuffer byteBuffer) {
            this.bufferQueue.offer(byteBuffer);
        }
    }

    private static interface BufferQueue {
        public ByteBuffer getByteBuffer() throws AerospikeException;

        public void putByteBuffer(ByteBuffer var1);
    }
}

