/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.SelectorManager;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public final class AsyncConnection
implements Closeable {
    private final SocketChannel socketChannel;
    private final SelectorManager manager;
    private SelectionKey key;
    private final long maxSocketIdleMillis;
    private long lastUsed;

    public AsyncConnection(InetSocketAddress address, AsyncCluster cluster) throws AerospikeException.Connection {
        this.manager = cluster.getSelectorManager();
        this.maxSocketIdleMillis = (long)cluster.getMaxSocketIdle() * 1000L;
        try {
            this.socketChannel = SocketChannel.open();
        }
        catch (Exception e) {
            throw new AerospikeException.Connection("SocketChannel open error: " + e.getMessage());
        }
        try {
            this.socketChannel.configureBlocking(false);
            Socket socket = this.socketChannel.socket();
            socket.setTcpNoDelay(true);
            this.socketChannel.connect(address);
            this.lastUsed = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.close();
            throw new AerospikeException.Connection("SocketChannel init error: " + e.getMessage());
        }
    }

    public void execute(AsyncCommand command) {
        this.manager.execute(command);
    }

    public void register(AsyncCommand command, Selector selector) throws ClosedChannelException {
        if (this.key != null) {
            this.key.attach(command);
            this.key.interestOps(4);
        } else {
            this.key = this.socketChannel.register(selector, 8, command);
        }
    }

    public void unregister() {
        this.key.interestOps(0);
        this.key.attach(null);
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        this.socketChannel.write(byteBuffer);
        if (!byteBuffer.hasRemaining()) {
            byteBuffer.clear();
            byteBuffer.limit(8);
            this.key.interestOps(1);
        }
    }

    public void setReadable() {
        this.key.interestOps(1);
        this.manager.wakeup();
    }

    public boolean read(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int len2 = this.socketChannel.read(byteBuffer);
            if (len2 == 0) {
                return false;
            }
            if (len2 >= 0) continue;
            throw new EOFException();
        }
        return true;
    }

    public boolean isValid() {
        return this.socketChannel.isConnected() && System.currentTimeMillis() - this.lastUsed <= this.maxSocketIdleMillis;
    }

    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public void close() {
        block3: {
            if (this.key != null) {
                this.key.cancel();
                this.key = null;
            }
            try {
                this.socketChannel.close();
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) break block3;
                Log.debug("Error closing socket: " + Util.getErrorMessage(e));
            }
        }
    }
}

