/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class AsyncRead
extends AsyncSingleCommand {
    private final Policy policy;
    private final RecordListener listener;
    private final String[] binNames;
    private Record record;

    public AsyncRead(AsyncCluster cluster, Policy policy, RecordListener listener, Key key, String[] binNames) {
        super(cluster, key);
        this.policy = policy;
        this.listener = listener;
        this.binNames = binNames;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setRead(this.key, this.binNames);
    }

    @Override
    protected final void parseResult(ByteBuffer byteBuffer) throws AerospikeException {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.receiveSize > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.receiveSize);
        }
        byteBuffer.position(0);
        byteBuffer.get(this.dataBuffer, 0, this.receiveSize);
        int resultCode = this.dataBuffer[5] & 0xFF;
        int generation = Buffer.bytesToInt(this.dataBuffer, 6);
        int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
        int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
        int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
        this.dataOffset = 22;
        if (resultCode == 0) {
            this.record = opCount == 0 ? new Record(null, generation, expiration) : this.parseRecord(opCount, fieldCount, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    private final Record parseRecord(int opCount, int fieldCount, int generation, int expiration) throws AerospikeException {
        if (fieldCount > 0) {
            for (int i = 0; i < fieldCount; ++i) {
                int fieldSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                this.dataOffset += 4 + fieldSize;
            }
        }
        HashMap<String, Object> bins = null;
        for (int i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = null;
            value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            bins.put(name, value);
        }
        return new Record(bins, generation, expiration);
    }

    @Override
    protected final void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected final void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

