/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.command.AdminCommand;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class Node
implements Closeable {
    public static final int PARTITIONS = 4096;
    protected final Cluster cluster;
    private final String name;
    private final Host host;
    private Host[] aliases;
    protected final InetSocketAddress address;
    private final ArrayBlockingQueue<Connection> connectionQueue;
    private int partitionGeneration;
    protected int referenceCount;
    protected int failures;
    protected volatile boolean active;

    public Node(Cluster cluster, NodeValidator nv) {
        this.cluster = cluster;
        this.name = nv.name;
        this.aliases = nv.aliases;
        this.address = nv.address;
        this.host = this.aliases[0];
        this.connectionQueue = new ArrayBlockingQueue(cluster.connectionQueueSize);
        this.partitionGeneration = -1;
        this.active = true;
    }

    public final void refresh(List<Host> friends) throws Exception {
        Connection conn = this.getConnection(1000);
        try {
            HashMap<String, String> infoMap = Info.request(conn, "node", "partition-generation", "services");
            this.verifyNodeName(infoMap);
            if (this.addFriends(infoMap, friends)) {
                this.updatePartitions(conn, infoMap);
            }
            this.putConnection(conn);
        }
        catch (Exception e) {
            conn.close();
            throw e;
        }
    }

    private final void verifyNodeName(HashMap<String, String> infoMap) throws AerospikeException {
        String infoName = infoMap.get("node");
        if (infoName == null || infoName.length() == 0) {
            throw new AerospikeException.Parse("Node name is empty");
        }
        if (!this.name.equals(infoName)) {
            this.active = false;
            throw new AerospikeException("Node name has changed. Old=" + this.name + " New=" + infoName);
        }
    }

    private final boolean addFriends(HashMap<String, String> infoMap, List<Host> friends) throws AerospikeException {
        String[] friendNames;
        String friendString = infoMap.get("services");
        if (friendString == null || friendString.length() == 0) {
            int nodeCount = this.cluster.getNodes().length;
            if (nodeCount > 2) {
                if (Log.warnEnabled()) {
                    Log.warn("Node " + this + " thinks it owns cluster, but client sees " + nodeCount + " nodes.");
                }
                return false;
            }
            return true;
        }
        for (String friend : friendNames = friendString.split(";")) {
            int port;
            Host alias;
            Node node;
            String alternativeHost;
            String[] friendInfo = friend.split(":");
            String host = friendInfo[0];
            if (this.cluster.ipMap != null && (alternativeHost = this.cluster.ipMap.get(host)) != null) {
                host = alternativeHost;
            }
            if ((node = this.cluster.findAlias(alias = new Host(host, port = Integer.parseInt(friendInfo[1])))) != null) {
                ++node.referenceCount;
                continue;
            }
            if (Node.findAlias(friends, alias)) continue;
            friends.add(alias);
        }
        return true;
    }

    private static final boolean findAlias(List<Host> friends, Host alias) {
        for (Host host : friends) {
            if (!host.equals(alias)) continue;
            return true;
        }
        return false;
    }

    private final void updatePartitions(Connection conn, HashMap<String, String> infoMap) throws AerospikeException, IOException {
        String genString = infoMap.get("partition-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("partition-generation is empty");
        }
        int generation = Integer.parseInt(genString);
        if (this.partitionGeneration != generation) {
            if (Log.debugEnabled()) {
                Log.debug("Node " + this + " partition generation " + generation + " changed.");
            }
            this.partitionGeneration = this.cluster.updatePartitions(conn, this);
        }
    }

    public final Connection getConnection(int timeoutMillis) throws AerospikeException {
        Connection conn;
        while ((conn = this.connectionQueue.poll()) != null) {
            if (conn.isValid()) {
                try {
                    conn.setTimeout(timeoutMillis);
                    return conn;
                }
                catch (Exception e) {
                    conn.close();
                    throw new AerospikeException.Connection(e);
                }
            }
            conn.close();
        }
        conn = new Connection(this.address, timeoutMillis, this.cluster.maxSocketIdle);
        if (this.cluster.user != null) {
            try {
                AdminCommand command = new AdminCommand();
                command.authenticate(conn, this.cluster.user, this.cluster.password);
            }
            catch (AerospikeException ae) {
                conn.close();
                throw ae;
            }
            catch (Exception e) {
                conn.close();
                throw new AerospikeException(e);
            }
        }
        return conn;
    }

    public final void putConnection(Connection conn) {
        if (!this.active || !this.connectionQueue.offer(conn)) {
            conn.close();
        }
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getName() {
        return this.name;
    }

    public final Host[] getAliases() {
        return this.aliases;
    }

    public final void addAlias(Host aliasToAdd) {
        Host[] tmpAliases = new Host[this.aliases.length + 1];
        int count = 0;
        for (Host host : this.aliases) {
            tmpAliases[count++] = host;
        }
        tmpAliases[count] = aliasToAdd;
        this.aliases = tmpAliases;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public final void close() {
        this.active = false;
        this.closeConnections();
    }

    public final String toString() {
        return this.name + ' ' + this.host;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        Node other = (Node)obj;
        return this.name.equals(other.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            this.closeConnections();
        }
        finally {
            super.finalize();
        }
    }

    protected void closeConnections() {
        Connection conn;
        while ((conn = this.connectionQueue.poll()) != null) {
            conn.close();
        }
    }
}

