/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import gnu.crypto.util.Base64;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionInfo {
    private final StringBuilder sb;
    private final byte[] buffer;
    private int length;
    private int offset;

    public PartitionInfo(Connection conn, String ... names) throws AerospikeException {
        Info info = new Info(conn, names);
        this.length = info.getLength();
        if (this.length == 0) {
            throw new AerospikeException.Parse("Partition info is empty");
        }
        this.buffer = info.getBuffer();
        this.sb = new StringBuilder(32);
    }

    public int parseGeneration() throws AerospikeException {
        this.expectName("partition-generation");
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 10) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                ++this.offset;
                return Integer.parseInt(s);
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find partition-generation value");
    }

    public HashMap<String, AtomicReferenceArray<Node>> parsePartitions(HashMap<String, AtomicReferenceArray<Node>> map, Node node) throws AerospikeException {
        this.expectName("replicas-master");
        int begin = this.offset;
        boolean copied = false;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                if (this.offset == begin) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                }
                AtomicReferenceArray<Node> nodeArray = map.get(namespace);
                if (nodeArray == null) {
                    if (!copied) {
                        map = new HashMap<String, AtomicReferenceArray<Node>>(map);
                        copied = true;
                    }
                    nodeArray = new AtomicReferenceArray<Node>(new Node[4096]);
                    map.put(namespace, nodeArray);
                }
                int bitMapLength = this.offset - begin;
                byte[] restoreBuffer = Base64.decode((byte[])this.buffer, (int)begin, (int)bitMapLength);
                for (int i = 0; i < 4096; ++i) {
                    if ((restoreBuffer[i >> 3] & 128 >> (i & 7)) == 0) continue;
                    nodeArray.lazySet(i, node);
                }
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
        return copied ? map : null;
    }

    private void expectName(String name) throws AerospikeException {
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 9) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (!name.equals(s)) break;
                ++this.offset;
                return;
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find " + name);
    }

    private String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }
}

