/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.UserRoles;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.util.ThreadLocalData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mindrot.jbcrypt.BCrypt;

public final class AdminCommand {
    private static final byte AUTHENTICATE = 0;
    private static final byte CREATE_USER = 1;
    private static final byte DROP_USER = 2;
    private static final byte SET_PASSWORD = 3;
    private static final byte CHANGE_PASSWORD = 4;
    private static final byte GRANT_ROLES = 5;
    private static final byte REVOKE_ROLES = 6;
    private static final byte REPLACE_ROLES = 7;
    private static final byte QUERY_USERS = 9;
    private static final byte USER = 0;
    private static final byte PASSWORD = 1;
    private static final byte OLD_PASSWORD = 2;
    private static final byte CREDENTIAL = 3;
    private static final byte ROLES = 10;
    private static final long MSG_VERSION = 0L;
    private static final long MSG_TYPE = 2L;
    private static final int FIELD_HEADER_SIZE = 5;
    private static final int HEADER_SIZE = 24;
    private static final int HEADER_REMAINING = 16;
    private static final int RESULT_CODE = 9;
    private static final int QUERY_END = 50;
    private byte[] dataBuffer;
    private int dataOffset;

    public AdminCommand() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        this.dataOffset = 8;
    }

    public AdminCommand(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
        this.dataOffset = 8;
    }

    public void authenticate(Connection conn, byte[] user, byte[] password) throws AerospikeException, IOException {
        this.setAuthenticate(user, password);
        conn.write(this.dataBuffer, this.dataOffset);
        conn.readFully(this.dataBuffer, 24);
        byte result = this.dataBuffer[9];
        if (result != 0) {
            throw new AerospikeException((int)result, "Authentication failed");
        }
    }

    public int setAuthenticate(byte[] user, byte[] password) {
        this.writeHeader((byte)0, 2);
        this.writeField((byte)0, user);
        this.writeField((byte)3, password);
        this.writeSize();
        return this.dataOffset;
    }

    public void createUser(Cluster cluster, AdminPolicy policy, String user, String password, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)1, 3);
        this.writeField((byte)0, user);
        this.writeField((byte)1, password);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void dropUser(Cluster cluster, AdminPolicy policy, String user) throws AerospikeException {
        this.writeHeader((byte)2, 1);
        this.writeField((byte)0, user);
        this.executeCommand(cluster, policy);
    }

    public void setPassword(Cluster cluster, AdminPolicy policy, byte[] user, String password) throws AerospikeException {
        this.writeHeader((byte)3, 2);
        this.writeField((byte)0, user);
        this.writeField((byte)1, password);
        this.executeCommand(cluster, policy);
    }

    public void changePassword(Cluster cluster, AdminPolicy policy, byte[] user, String password) throws AerospikeException {
        this.writeHeader((byte)4, 3);
        this.writeField((byte)0, user);
        this.writeField((byte)2, cluster.getPassword());
        this.writeField((byte)1, password);
        this.executeCommand(cluster, policy);
    }

    public void grantRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)5, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void revokeRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)6, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void replaceRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)7, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public UserRoles queryUser(Cluster cluster, AdminPolicy policy, String user) throws AerospikeException {
        ArrayList<UserRoles> list = new ArrayList<UserRoles>(1);
        this.writeHeader((byte)9, 1);
        this.writeField((byte)0, user);
        this.readUsers(cluster, policy, list);
        return list.size() > 0 ? (UserRoles)list.get(0) : null;
    }

    public List<UserRoles> queryUsers(Cluster cluster, AdminPolicy policy) throws AerospikeException {
        ArrayList<UserRoles> list = new ArrayList<UserRoles>(100);
        this.writeHeader((byte)9, 0);
        this.readUsers(cluster, policy, list);
        return list;
    }

    private void writeRoles(List<String> roles) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)roles.size();
        for (String role : roles) {
            int len2 = Buffer.stringToUtf8(role, this.dataBuffer, offset + 1);
            this.dataBuffer[offset] = (byte)len2;
            offset += len2 + 1;
        }
        int size = offset - this.dataOffset - 5;
        this.writeFieldHeader((byte)10, size);
        this.dataOffset = offset;
    }

    private void writeSize() {
        long size = (long)this.dataOffset - 8L | 0L | 0x2000000000000L;
        Buffer.longToBytes(size, this.dataBuffer, 0);
    }

    private void writeHeader(byte command, int fieldCount) {
        Arrays.fill(this.dataBuffer, this.dataOffset, this.dataOffset + 16, (byte)0);
        this.dataBuffer[this.dataOffset + 2] = command;
        this.dataBuffer[this.dataOffset + 3] = (byte)fieldCount;
        this.dataOffset += 16;
    }

    private void writeField(byte id, String str) {
        int len2 = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(id, len2);
        this.dataOffset += len2;
    }

    private void writeField(byte id, byte[] bytes) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(id, bytes.length);
        this.dataOffset += bytes.length;
    }

    private void writeFieldHeader(byte id, int size) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = id;
    }

    private void executeCommand(Cluster cluster, AdminPolicy policy) throws AerospikeException {
        this.writeSize();
        Node node = cluster.getRandomNode();
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            conn.write(this.dataBuffer, this.dataOffset);
            conn.readFully(this.dataBuffer, 24);
            node.putConnection(conn);
        }
        catch (Exception e) {
            conn.close();
            throw new AerospikeException(e);
        }
        byte result = this.dataBuffer[9];
        if (result != 0) {
            throw new AerospikeException(result);
        }
    }

    public void readUsers(Cluster cluster, AdminPolicy policy, List<UserRoles> list) throws AerospikeException {
        this.writeSize();
        Node node = cluster.getRandomNode();
        int timeout = policy == null ? 1000 : policy.timeout;
        int status = 0;
        Connection conn = node.getConnection(timeout);
        try {
            conn.write(this.dataBuffer, this.dataOffset);
            status = this.readUserBlocks(conn, list);
            node.putConnection(conn);
        }
        catch (Exception e) {
            conn.close();
            throw new AerospikeException(e);
        }
        if (status > 0) {
            throw new AerospikeException(status, "Query users failed.");
        }
    }

    private int readUserBlocks(Connection conn, List<UserRoles> list) throws IOException {
        int status = 0;
        while (status == 0) {
            conn.readFully(this.dataBuffer, 8);
            long size = Buffer.bytesToLong(this.dataBuffer, 0);
            int receiveSize = (int)(size & 0xFFFFFFFFFFFFL);
            if (receiveSize <= 0) break;
            if (receiveSize > this.dataBuffer.length) {
                this.dataBuffer = ThreadLocalData.resizeBuffer(receiveSize);
            }
            conn.readFully(this.dataBuffer, receiveSize);
            status = this.parseUsers(list, receiveSize);
        }
        return status;
    }

    private int parseUsers(List<UserRoles> list, int receiveSize) {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            byte resultCode = this.dataBuffer[this.dataOffset + 1];
            if (resultCode != 0) {
                if (resultCode == 50) {
                    return -1;
                }
                return resultCode;
            }
            UserRoles userRoles = new UserRoles();
            int fieldCount = this.dataBuffer[this.dataOffset + 3];
            this.dataOffset += 16;
            for (int i = 0; i < fieldCount; ++i) {
                int len2 = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                this.dataOffset += 4;
                byte id = this.dataBuffer[this.dataOffset++];
                --len2;
                if (id == 0) {
                    userRoles.user = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len2);
                    this.dataOffset += len2;
                    continue;
                }
                if (id == 10) {
                    this.parseRoles(userRoles);
                    continue;
                }
                this.dataOffset += len2;
            }
            if (userRoles.user == null && userRoles.roles == null) continue;
            if (userRoles.roles == null) {
                userRoles.roles = new ArrayList<String>(0);
            }
            list.add(userRoles);
        }
        return 0;
    }

    private void parseRoles(UserRoles userRoles) {
        int size = this.dataBuffer[this.dataOffset++];
        userRoles.roles = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            byte len2 = this.dataBuffer[this.dataOffset++];
            String role = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, len2);
            this.dataOffset += len2;
            userRoles.roles.add(role);
        }
    }

    public static String hashPassword(String password) {
        return BCrypt.hashpw((String)password, (String)"$2a$10$7EqJtq98hPqEX7fNZaFWoO");
    }
}

