/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchCommandExists;
import com.aerospike.client.command.BatchCommandGet;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import java.util.HashSet;
import java.util.List;

public final class BatchExecutor {
    public static void execute(Cluster cluster, BatchPolicy policy, Key[] keys2, boolean[] existsArray, Record[] records, HashSet<String> binNames, int readAttr) throws AerospikeException {
        if (keys2.length == 0) {
            return;
        }
        List<BatchNode> batchNodes = BatchNode.generateList(cluster, keys2);
        if (policy.maxConcurrentThreads == 1) {
            for (BatchNode batchNode : batchNodes) {
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    MultiCommand command;
                    if (records != null) {
                        command = new BatchCommandGet(batchNode.node, batchNamespace, policy, keys2, binNames, records, readAttr);
                        command.execute();
                        continue;
                    }
                    command = new BatchCommandExists(batchNode.node, batchNamespace, policy, keys2, existsArray);
                    command.execute();
                }
            }
        } else {
            Executor executor = new Executor(cluster, batchNodes.size() * 2);
            for (BatchNode batchNode : batchNodes) {
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    MultiCommand command;
                    if (records != null) {
                        command = new BatchCommandGet(batchNode.node, batchNamespace, policy, keys2, binNames, records, readAttr);
                        executor.addCommand(command);
                        continue;
                    }
                    command = new BatchCommandExists(batchNode.node, batchNamespace, policy, keys2, existsArray);
                    executor.addCommand(command);
                }
            }
            executor.execute(policy.maxConcurrentThreads);
        }
    }
}

