/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.large;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.WritePolicy;
import java.util.List;
import java.util.Map;

public final class LargeList {
    private static final String PackageName = "llist";
    private final AerospikeClient client;
    private final WritePolicy policy;
    private final Key key;
    private final Value binName;
    private final Value userModule;

    public LargeList(AerospikeClient client, WritePolicy policy, Key key, String binName, String userModule) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
        this.userModule = Value.get(userModule);
    }

    public final void add(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "add", this.binName, value, this.userModule);
    }

    public final void add(Value ... values2) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "add_all", this.binName, Value.get(values2), this.userModule);
    }

    public final void add(List<?> values2) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "add_all", this.binName, Value.getAsList(values2), this.userModule);
    }

    public final void update(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "update", this.binName, value, this.userModule);
    }

    public final void update(Value ... values2) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "update_all", this.binName, Value.get(values2), this.userModule);
    }

    public final void update(List<?> values2) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "update_all", this.binName, Value.getAsList(values2), this.userModule);
    }

    public final void remove(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "remove", this.binName, value);
    }

    public final List<?> find(Value value) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find", this.binName, value);
    }

    public final List<?> findThenFilter(Value value, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_then_filter", this.binName, value, this.userModule, Value.get(filterName), Value.get(filterArgs));
    }

    public final List<?> range(Value minValue, Value maxValue) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "range", this.binName, minValue, maxValue);
    }

    public final List<?> range(Value minValue, Value maxValue, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "range", this.binName, minValue, maxValue, this.userModule, Value.get(filterName), Value.get(filterArgs));
    }

    public final List<?> scan() throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "scan", this.binName);
    }

    public final List<?> filter(String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "filter", this.binName, this.userModule, Value.get(filterName), Value.get(filterArgs));
    }

    public final void destroy() throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "destroy", this.binName);
    }

    public final int size() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "size", this.binName);
        return result != null ? (Integer)result : 0;
    }

    public final Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "config", this.binName);
    }

    public final void setCapacity(int capacity) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "set_capacity", this.binName, Value.get(capacity));
    }

    public final int getCapacity() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "get_capacity", this.binName);
        return result != null ? (Integer)result : 0;
    }
}

