/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.large;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.WritePolicy;
import java.util.Map;

public final class LargeMap {
    private static final String PackageName = "lmap";
    private final AerospikeClient client;
    private final WritePolicy policy;
    private final Key key;
    private final Value binName;
    private final Value userModule;

    public LargeMap(AerospikeClient client, WritePolicy policy, Key key, String binName, String userModule) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
        this.userModule = Value.get(userModule);
    }

    public final void put(Value name, Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "put", this.binName, name, value, this.userModule);
    }

    public final void put(Map<?, ?> map) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "put_all", this.binName, Value.getAsMap(map), this.userModule);
    }

    public final Map<?, ?> get(Value name) throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "get", this.binName, name);
    }

    public final boolean exists(Value keyValue) throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "exists", this.binName, keyValue);
        return result != null ? (Integer)result != 0 : false;
    }

    public final Map<?, ?> scan() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "scan", this.binName);
    }

    public final Map<?, ?> filter(String filterName, Value ... filterArgs) throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "filter", this.binName, this.userModule, Value.get(filterName), Value.get(filterArgs));
    }

    public final void remove(Value name) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "remove", this.binName, name, this.userModule);
    }

    public final void destroy() throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "destroy", this.binName);
    }

    public final int size() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "size", this.binName);
        return result != null ? (Integer)result : 0;
    }

    public final Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "config", this.binName);
    }

    public final void setCapacity(int capacity) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "set_capacity", this.binName, Value.get(capacity));
    }

    public final int getCapacity() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "get_capacity", this.binName);
        return result != null ? (Integer)result : 0;
    }
}

