/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaData;
import com.aerospike.client.lua.LuaInstance;
import org.luaj.vm2.LuaUserdata;

public final class LuaBytes
extends LuaUserdata
implements LuaData {
    private byte[] bytes;
    private int size;
    private int type;

    public LuaBytes(LuaInstance instance, int capacity) {
        super((Object)new byte[capacity]);
        this.bytes = (byte[])this.m_instance;
        this.setmetatable(instance.getPackage("Bytes"));
    }

    public LuaBytes(LuaInstance instance, byte[] bytes) {
        super((Object)bytes);
        this.bytes = bytes;
        this.size = bytes.length;
        this.setmetatable(instance.getPackage("Bytes"));
    }

    public void appendBigInt16(short value) {
        this.setBigInt16(value, this.size);
    }

    public void appendLittleInt16(short value) {
        this.setLittleInt16(value, this.size);
    }

    public void appendBigInt32(int value) {
        this.setBigInt32(value, this.size);
    }

    public void appendLittleInt32(int value) {
        this.setLittleInt32(value, this.size);
    }

    public void appendBigInt64(long value) {
        this.setBigInt64(value, this.size);
    }

    public void appendLittleInt64(long value) {
        this.setLittleInt64(value, this.size);
    }

    public int appendVarInt(int value) {
        return this.setVarInt(value, this.size);
    }

    public void appendString(String value) {
        this.setString(value, this.size);
    }

    public void appendBytes(LuaBytes value, int length) {
        this.setBytes(value, this.size, length);
    }

    public void appendByte(byte value) {
        this.setByte(value, this.size);
    }

    public void setBigInt16(short value, int offset) {
        int capacity = offset + 2;
        this.ensureCapacity(capacity);
        Buffer.shortToBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setLittleInt16(short value, int offset) {
        int capacity = offset + 2;
        this.ensureCapacity(capacity);
        Buffer.shortToLittleBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setBigInt32(int value, int offset) {
        int capacity = offset + 4;
        this.ensureCapacity(capacity);
        Buffer.intToBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setLittleInt32(int value, int offset) {
        int capacity = offset + 4;
        this.ensureCapacity(capacity);
        Buffer.intToLittleBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setBigInt64(long value, int offset) {
        int capacity = offset + 8;
        this.ensureCapacity(capacity);
        Buffer.longToBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setLittleInt64(long value, int offset) {
        int capacity = offset + 8;
        this.ensureCapacity(capacity);
        Buffer.longToLittleBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public int setVarInt(int value, int offset) {
        this.ensureCapacity(offset + 5);
        int len2 = Buffer.intToVarBytes(value, this.bytes, offset);
        this.resetSize(offset + len2);
        return len2;
    }

    public int setString(String value, int offset) {
        int len2 = Buffer.estimateSizeUtf8(value);
        this.ensureCapacity(offset + len2);
        len2 = Buffer.stringToUtf8(value, this.bytes, offset);
        this.resetSize(offset + len2);
        return len2;
    }

    public void setBytes(LuaBytes value, int offset, int length) {
        if (length == 0 || length > value.size) {
            length = value.size;
        }
        int capacity = offset + length;
        this.ensureCapacity(capacity);
        System.arraycopy(value.bytes, 0, this.bytes, offset, length);
        this.resetSize(capacity);
    }

    public void setByte(byte value, int offset) {
        int capacity = offset + 1;
        this.ensureCapacity(capacity);
        this.bytes[offset] = value;
        this.resetSize(capacity);
    }

    public byte getByte(int offset) {
        return this.bytes[offset];
    }

    public int getBigInt16(int offset) {
        return Buffer.bytesToShort(this.bytes, offset);
    }

    public int getLittleInt16(int offset) {
        return Buffer.littleBytesToShort(this.bytes, offset);
    }

    public int getBigInt32(int offset) {
        return Buffer.bytesToInt(this.bytes, offset);
    }

    public int getLittleInt32(int offset) {
        return Buffer.littleBytesToInt(this.bytes, offset);
    }

    public long getBigInt64(int offset) {
        return Buffer.bytesToLong(this.bytes, offset);
    }

    public long getLittleInt64(int offset) {
        return Buffer.littleBytesToLong(this.bytes, offset);
    }

    public int[] getVarInt(int offset) {
        return Buffer.varBytesToInt(this.bytes, offset);
    }

    public String getString(int offset, int length) {
        return Buffer.utf8ToString(this.bytes, offset, length);
    }

    public byte[] getBytes(int offset, int length) {
        byte[] target = new byte[length];
        System.arraycopy(this.bytes, offset, target, 0, length);
        return target;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.bytes.length) {
            int len2 = this.bytes.length * 2;
            if (capacity > len2) {
                len2 = capacity;
            }
            byte[] target = new byte[len2];
            System.arraycopy(this.bytes, 0, target, 0, this.size);
            this.bytes = target;
        }
    }

    private void resetSize(int capacity) {
        if (capacity > this.size) {
            this.size = capacity;
        }
    }

    public void setCapacity(int capacity) {
        if (this.bytes.length == capacity) {
            return;
        }
        byte[] target = new byte[capacity];
        if (this.size > capacity) {
            this.size = capacity;
        }
        System.arraycopy(this.bytes, 0, target, 0, this.size);
        this.bytes = target;
    }

    @Override
    public Object luaToObject() {
        return this.bytes;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return Buffer.bytesToHexString(this.bytes, 0, this.size);
    }
}

