/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaData;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;

public final class LuaList
extends LuaUserdata
implements LuaData {
    private final LuaInstance instance;
    private final List<LuaValue> list;

    public LuaList(LuaInstance instance, List<LuaValue> list) {
        super(list);
        this.instance = instance;
        this.list = list;
        this.setmetatable(instance.getPackage("List"));
    }

    public LuaValue get(LuaValue index2) {
        return this.list.get(index2.toint() - 1);
    }

    public void set(LuaValue index2, LuaValue value) {
        int i = index2.toint();
        this.ensureSize(i);
        this.list.set(i - 1, value);
    }

    private void ensureSize(int size) {
        if (size > this.list.size()) {
            for (int i = this.list.size(); i < size; ++i) {
                this.list.add(LuaValue.NIL);
            }
        }
    }

    public void append(LuaValue value) {
        this.list.add(value);
    }

    public void prepend(LuaValue value) {
        this.list.add(0, value);
    }

    public final LuaList take(LuaValue items) {
        int max = items.toint();
        if (max > this.list.size()) {
            max = this.list.size();
        }
        return this.subList(0, max);
    }

    public final LuaList drop(LuaValue count) {
        int min = count.toint();
        if (min > this.list.size()) {
            min = this.list.size();
        }
        return this.subList(min, this.list.size());
    }

    public LuaList subList(int begin, int end) {
        return new LuaList(this.instance, this.list.subList(begin, end));
    }

    public Iterator<LuaValue> iterator() {
        return this.list.iterator();
    }

    public LuaString toLuaString() {
        return LuaString.valueOf((String)this.list.toString());
    }

    public LuaInteger size() {
        return LuaInteger.valueOf((int)this.list.size());
    }

    @Override
    public Object luaToObject() {
        ArrayList<Object> target = new ArrayList<Object>(this.list.size());
        for (LuaValue luaValue : this.list) {
            Object obj = LuaUtil.luaToObject(luaValue);
            target.add(obj);
        }
        return target;
    }
}

