/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaList;
import java.util.ArrayList;
import java.util.Iterator;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public final class LuaListLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaListLib(LuaInstance instance) {
        this.instance = instance;
        instance.load((LibFunction)new MetaLib(instance));
    }

    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 8);
        table.setmetatable((LuaValue)meta);
        table.set("size", (LuaValue)new len());
        table.set("iterator", (LuaValue)new iterator());
        table.set("append", (LuaValue)new append());
        table.set("prepend", (LuaValue)new prepend());
        table.set("take", (LuaValue)new take());
        table.set("drop", (LuaValue)new drop());
        this.instance.registerPackage("list", table);
        return table;
    }

    public static final class newindex
    extends ThreeArgFunction {
        public LuaValue call(LuaValue l, LuaValue index2, LuaValue value) {
            LuaList list = (LuaList)l;
            list.set(index2, value);
            return NIL;
        }
    }

    public static final class index
    extends TwoArgFunction {
        public LuaValue call(LuaValue l, LuaValue index2) {
            LuaList list = (LuaList)l;
            return list.get(index2);
        }
    }

    public static final class tostring
    extends OneArgFunction {
        public LuaValue call(LuaValue l) {
            LuaList list = (LuaList)l;
            return list.toLuaString();
        }
    }

    public static final class len
    extends OneArgFunction {
        public LuaValue call(LuaValue l) {
            LuaList list = (LuaList)l;
            return list.size();
        }
    }

    public static final class drop
    extends TwoArgFunction {
        public LuaValue call(LuaValue l, LuaValue count) {
            LuaList list = (LuaList)l;
            return list.drop(count);
        }
    }

    public static final class take
    extends TwoArgFunction {
        public LuaValue call(LuaValue l, LuaValue count) {
            LuaList list = (LuaList)l;
            return list.take(count);
        }
    }

    public static final class prepend
    extends TwoArgFunction {
        public LuaValue call(LuaValue l, LuaValue value) {
            LuaList list = (LuaList)l;
            list.prepend(value);
            return NIL;
        }
    }

    public static final class append
    extends TwoArgFunction {
        public LuaValue call(LuaValue l, LuaValue value) {
            LuaList list = (LuaList)l;
            list.append(value);
            return NIL;
        }
    }

    public static final class nextLuaValue
    extends ZeroArgFunction {
        private final Iterator<LuaValue> iter;

        public nextLuaValue(Iterator<LuaValue> iter) {
            this.iter = iter;
        }

        public LuaValue call() {
            return this.iter.hasNext() ? this.iter.next() : LuaValue.NIL;
        }
    }

    public static final class iterator
    extends OneArgFunction {
        public LuaValue call(LuaValue l) {
            LuaList list = (LuaList)l;
            return new nextLuaValue(list.iterator());
        }
    }

    public static final class create
    extends VarArgFunction {
        private final LuaInstance instance;

        public create(LuaInstance instance) {
            this.instance = instance;
        }

        public Varargs invoke(Varargs args) {
            LuaList list = new LuaList(this.instance, new ArrayList<LuaValue>());
            if (args.istable(2)) {
                Varargs n;
                LuaTable table = args.checktable(2);
                LuaValue k = LuaValue.NIL;
                while (!(k = (n = table.next(k)).arg1()).isnil()) {
                    LuaValue v = n.arg(2);
                    list.append(v);
                }
            }
            return LuaValue.varargsOf((LuaValue[])new LuaValue[]{list});
        }
    }

    public static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            meta.set("__len", (LuaValue)new len());
            meta.set("__tostring", (LuaValue)new tostring());
            meta.set("__index", (LuaValue)new index());
            meta.set("__newindex", (LuaValue)new newindex());
            this.instance.registerPackage("List", meta);
            return meta;
        }
    }
}

