/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaListLib;
import com.aerospike.client.lua.LuaMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public final class LuaMapLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaMapLib(LuaInstance instance) {
        this.instance = instance;
        instance.load((LibFunction)new MetaLib(instance));
    }

    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 8);
        table.setmetatable((LuaValue)meta);
        table.set("size", (LuaValue)new len());
        table.set("pairs", (LuaValue)new iterator());
        table.set("keys", (LuaValue)new keys());
        table.set("values", (LuaValue)new values());
        this.instance.registerPackage("map", table);
        return table;
    }

    public static final class newindex
    extends ThreeArgFunction {
        public LuaValue call(LuaValue m, LuaValue key, LuaValue value) {
            LuaMap map = (LuaMap)m;
            map.put(key, value);
            return NIL;
        }
    }

    public static final class index
    extends TwoArgFunction {
        public LuaValue call(LuaValue m, LuaValue key) {
            LuaMap map = (LuaMap)m;
            return map.get(key);
        }
    }

    public static final class tostring
    extends OneArgFunction {
        public LuaValue call(LuaValue m) {
            LuaMap map = (LuaMap)m;
            return map.toLuaString();
        }
    }

    public static final class len
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            return map.size();
        }
    }

    public static final class values
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            return new LuaListLib.nextLuaValue(map.valuesIterator());
        }
    }

    public static final class keys
    extends OneArgFunction {
        public LuaValue call(LuaValue m) {
            LuaMap map = (LuaMap)m;
            return new LuaListLib.nextLuaValue(map.keySetIterator());
        }
    }

    public static final class nextLuaValue
    extends VarArgFunction {
        private final Iterator<Map.Entry<LuaValue, LuaValue>> iter;

        public nextLuaValue(Iterator<Map.Entry<LuaValue, LuaValue>> iter) {
            this.iter = iter;
        }

        public Varargs invoke(Varargs args) {
            if (this.iter.hasNext()) {
                Map.Entry<LuaValue, LuaValue> entry = this.iter.next();
                return LuaValue.varargsOf((LuaValue[])new LuaValue[]{entry.getKey(), entry.getValue()});
            }
            return NONE;
        }
    }

    public static final class iterator
    extends OneArgFunction {
        public LuaValue call(LuaValue arg) {
            LuaMap map = (LuaMap)arg;
            return new nextLuaValue(map.entrySetIterator());
        }
    }

    public static final class create
    extends VarArgFunction {
        private final LuaInstance instance;

        public create(LuaInstance instance) {
            this.instance = instance;
        }

        public Varargs invoke(Varargs args) {
            LuaMap map = new LuaMap(this.instance, new HashMap<LuaValue, LuaValue>());
            if (args.istable(2)) {
                Varargs n;
                LuaTable table = args.checktable(2);
                LuaValue k = LuaValue.NIL;
                while (!(k = (n = table.next(k)).arg1()).isnil()) {
                    LuaValue v = n.arg(2);
                    map.put(k, v);
                }
            }
            return LuaValue.varargsOf((LuaValue[])new LuaValue[]{map});
        }
    }

    public static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            meta.set("__len", (LuaValue)new len());
            meta.set("__tostring", (LuaValue)new tostring());
            meta.set("__index", (LuaValue)new index());
            meta.set("__newindex", (LuaValue)new newindex());
            this.instance.registerPackage("Map", meta);
            return meta;
        }
    }
}

