/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;

public final class Filter {
    private final String name;
    private final Value begin;
    private final Value end;

    public static Filter equal(String name, long value) {
        Value val = Value.get(value);
        return new Filter(name, val, val);
    }

    public static Filter equal(String name, String value) {
        Value val = Value.get(value);
        return new Filter(name, val, val);
    }

    public static Filter equal(String name, Value value) {
        return new Filter(name, value, value);
    }

    public static Filter range(String name, long begin, long end) {
        return new Filter(name, Value.get(begin), Value.get(end));
    }

    public static Filter range(String name, Value begin, Value end) {
        return new Filter(name, begin, end);
    }

    private Filter(String name, Value begin, Value end) {
        this.name = name;
        this.begin = begin;
        this.end = end;
    }

    protected int estimateSize() throws AerospikeException {
        return Buffer.estimateSizeUtf8(this.name) + this.begin.estimateSize() + this.end.estimateSize() + 10;
    }

    protected int write(byte[] buf, int offset) throws AerospikeException {
        int len2 = Buffer.stringToUtf8(this.name, buf, offset + 1);
        buf[offset] = (byte)len2;
        offset += len2 + 1;
        buf[offset++] = (byte)this.begin.getType();
        len2 = this.begin.write(buf, offset + 4);
        Buffer.intToBytes(len2, buf, offset);
        offset += len2 + 4;
        len2 = this.end.write(buf, offset + 4);
        Buffer.intToBytes(len2, buf, offset);
        return offset += len2 + 4;
    }
}

