/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.QueryCommand;
import com.aerospike.client.query.Statement;
import java.io.IOException;

public final class ServerCommand
extends QueryCommand {
    private final WritePolicy writePolicy;

    public ServerCommand(Node node, WritePolicy policy, Statement statement) {
        super(node, policy, statement);
        this.writePolicy = policy;
    }

    @Override
    protected void writeQueryHeader(int fieldCount, int operationCount) {
        this.writeHeader(this.writePolicy, 1, 1, fieldCount, operationCount);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0) {
                if (resultCode == 2) {
                    return false;
                }
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            this.parseKey(fieldCount);
            for (int i = 0; i < opCount; ++i) {
                this.readBytes(8);
                int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
                byte nameSize = this.dataBuffer[7];
                this.readBytes(nameSize);
                int particleBytesSize = opSize - (4 + nameSize);
                this.readBytes(particleBytesSize);
            }
            if (this.valid) continue;
            throw new AerospikeException.QueryTerminated();
        }
        return true;
    }
}

