/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import java.util.Arrays;
import java.util.List;

public final class AsyncBatch {

    private static abstract class BaseExecutor
    extends AsyncMultiExecutor {
        protected final Key[] keys;
        protected final List<BatchNode> batchNodes;
        protected final int taskSize;

        public BaseExecutor(Cluster cluster, BatchPolicy policy, Key[] keys) {
            this.keys = keys;
            this.batchNodes = BatchNode.generateList(cluster, policy, keys);
            int size = 0;
            for (BatchNode batchNode : this.batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    ++size;
                    continue;
                }
                batchNode.splitByNamespace(keys);
                size += batchNode.batchNamespaces.size();
            }
            this.taskSize = size;
        }
    }

    private static final class ExistsSequenceDirect
    extends AsyncMultiCommand {
        private final BatchNode.BatchNamespace batch;
        private final Policy policy;
        private final Key[] keys;
        private final ExistsSequenceListener listener;
        private int index;

        public ExistsSequenceDirect(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, ExistsSequenceListener listener) {
            super(parent, cluster, node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchReadDirect(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            int offset = this.batch.offsets[this.index++];
            Key keyOrig = this.keys[offset];
            if (!Arrays.equals(key.digest, keyOrig.digest)) {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
            }
            this.listener.onExists(keyOrig, this.resultCode == 0);
        }
    }

    private static final class ExistsSequenceCommand
    extends AsyncMultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final Key[] keys;
        private final ExistsSequenceListener listener;

        public ExistsSequenceCommand(AsyncMultiExecutor parent, AsyncCluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, ExistsSequenceListener listener) {
            super(parent, cluster, (AsyncNode)batch.node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            Key keyOrig = this.keys[this.batchIndex];
            if (!Arrays.equals(key.digest, keyOrig.digest)) {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
            this.listener.onExists(keyOrig, this.resultCode == 0);
        }
    }

    public static final class ExistsSequenceExecutor
    extends BaseExecutor {
        private final ExistsSequenceListener listener;

        public ExistsSequenceExecutor(AsyncCluster cluster, BatchPolicy policy, Key[] keys, ExistsSequenceListener listener) {
            super(cluster, policy, keys);
            this.listener = listener;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[this.taskSize];
            int count = 0;
            for (BatchNode batchNode : this.batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    tasks[count++] = new ExistsSequenceCommand(this, cluster, batchNode, policy, keys, listener);
                    continue;
                }
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    tasks[count++] = new ExistsSequenceDirect(this, cluster, (AsyncNode)batchNode.node, batchNamespace, policy, keys, listener);
                }
            }
            this.execute(tasks, policy.maxConcurrentThreads);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ExistsArrayDirect
    extends AsyncMultiCommand {
        private final BatchNode.BatchNamespace batch;
        private final Policy policy;
        private final Key[] keys;
        private final boolean[] existsArray;
        private int index;

        public ExistsArrayDirect(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, boolean[] existsArray) {
            super(parent, cluster, node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchReadDirect(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            int offset = this.batch.offsets[this.index++];
            if (!Arrays.equals(key.digest, this.keys[offset].digest)) {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
            }
            this.existsArray[offset] = this.resultCode == 0;
        }
    }

    private static final class ExistsArrayCommand
    extends AsyncMultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(AsyncMultiExecutor parent, AsyncCluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, boolean[] existsArray) {
            super(parent, cluster, (AsyncNode)batch.node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            if (!Arrays.equals(key.digest, this.keys[this.batchIndex].digest)) {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }
    }

    public static final class ExistsArrayExecutor
    extends BaseExecutor {
        private final ExistsArrayListener listener;
        private final boolean[] existsArray;

        public ExistsArrayExecutor(AsyncCluster cluster, BatchPolicy policy, Key[] keys, ExistsArrayListener listener) {
            super(cluster, policy, keys);
            this.existsArray = new boolean[keys.length];
            this.listener = listener;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[this.taskSize];
            int count = 0;
            for (BatchNode batchNode : this.batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    tasks[count++] = new ExistsArrayCommand(this, cluster, batchNode, policy, keys, this.existsArray);
                    continue;
                }
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    tasks[count++] = new ExistsArrayDirect(this, cluster, (AsyncNode)batchNode.node, batchNamespace, policy, keys, this.existsArray);
                }
            }
            this.execute(tasks, policy.maxConcurrentThreads);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.existsArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class GetSequenceDirect
    extends AsyncMultiCommand {
        private final BatchNode.BatchNamespace batch;
        private final Policy policy;
        private final Key[] keys;
        private final String[] binNames;
        private final RecordSequenceListener listener;
        private final int readAttr;
        private int index;

        public GetSequenceDirect(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, String[] binNames, RecordSequenceListener listener, int readAttr) {
            super(parent, cluster, node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.binNames = binNames;
            this.listener = listener;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchReadDirect(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            int offset = this.batch.offsets[this.index++];
            Key keyOrig = this.keys[offset];
            if (Arrays.equals(key.digest, keyOrig.digest)) {
                if (this.resultCode == 0) {
                    Record record = this.parseRecord();
                    this.listener.onRecord(keyOrig, record);
                } else {
                    this.listener.onRecord(keyOrig, null);
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
            }
        }
    }

    private static final class GetSequenceCommand
    extends AsyncMultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final Key[] keys;
        private final String[] binNames;
        private final RecordSequenceListener listener;
        private final int readAttr;

        public GetSequenceCommand(AsyncMultiExecutor parent, AsyncCluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, RecordSequenceListener listener, int readAttr) {
            super(parent, cluster, (AsyncNode)batch.node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.binNames = binNames;
            this.listener = listener;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            Key keyOrig = this.keys[this.batchIndex];
            if (Arrays.equals(key.digest, keyOrig.digest)) {
                if (this.resultCode == 0) {
                    Record record = this.parseRecord();
                    this.listener.onRecord(keyOrig, record);
                } else {
                    this.listener.onRecord(keyOrig, null);
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
        }
    }

    public static final class GetSequenceExecutor
    extends BaseExecutor {
        private final RecordSequenceListener listener;

        public GetSequenceExecutor(AsyncCluster cluster, BatchPolicy policy, RecordSequenceListener listener, Key[] keys, String[] binNames, int readAttr) {
            super(cluster, policy, keys);
            this.listener = listener;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[this.taskSize];
            int count = 0;
            for (BatchNode batchNode : this.batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    tasks[count++] = new GetSequenceCommand(this, cluster, batchNode, policy, keys, binNames, listener, readAttr);
                    continue;
                }
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    tasks[count++] = new GetSequenceDirect(this, cluster, (AsyncNode)batchNode.node, batchNamespace, policy, keys, binNames, listener, readAttr);
                }
            }
            this.execute(tasks, policy.maxConcurrentThreads);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class GetArrayDirect
    extends AsyncMultiCommand {
        private final BatchNode.BatchNamespace batch;
        private final Policy policy;
        private final Key[] keys;
        private final String[] binNames;
        private final Record[] records;
        private final int readAttr;
        private int index;

        public GetArrayDirect(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, String[] binNames, Record[] records, int readAttr) {
            super(parent, cluster, node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.binNames = binNames;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchReadDirect(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            int offset = this.batch.offsets[this.index++];
            if (Arrays.equals(key.digest, this.keys[offset].digest)) {
                if (this.resultCode == 0) {
                    this.records[offset] = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
            }
        }
    }

    private static final class GetArrayCommand
    extends AsyncMultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final Key[] keys;
        private final String[] binNames;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(AsyncMultiExecutor parent, AsyncCluster cluster, BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, Record[] records, int readAttr) {
            super(parent, cluster, (AsyncNode)batch.node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.binNames = binNames;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            if (Arrays.equals(key.digest, this.keys[this.batchIndex].digest)) {
                if (this.resultCode == 0) {
                    this.records[this.batchIndex] = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
        }
    }

    public static final class GetArrayExecutor
    extends BaseExecutor {
        private final RecordArrayListener listener;
        private final Record[] recordArray;

        public GetArrayExecutor(AsyncCluster cluster, BatchPolicy policy, RecordArrayListener listener, Key[] keys, String[] binNames, int readAttr) {
            super(cluster, policy, keys);
            this.recordArray = new Record[keys.length];
            this.listener = listener;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[this.taskSize];
            int count = 0;
            for (BatchNode batchNode : this.batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    tasks[count++] = new GetArrayCommand(this, cluster, batchNode, policy, keys, binNames, this.recordArray, readAttr);
                    continue;
                }
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    tasks[count++] = new GetArrayDirect(this, cluster, (AsyncNode)batchNode.node, batchNamespace, policy, keys, binNames, this.recordArray, readAttr);
                }
            }
            this.execute(tasks, policy.maxConcurrentThreads);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.recordArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ReadSequenceCommand
    extends AsyncMultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final BatchSequenceListener listener;
        private final List<BatchRead> records;

        public ReadSequenceCommand(AsyncMultiExecutor parent, AsyncCluster cluster, BatchNode batch, BatchPolicy policy, BatchSequenceListener listener, List<BatchRead> records) {
            super(parent, cluster, (AsyncNode)batch.node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) {
            BatchRead record = this.records.get(this.batchIndex);
            if (Arrays.equals(key.digest, record.key.digest)) {
                if (this.resultCode == 0) {
                    record.record = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
            this.listener.onRecord(record);
        }
    }

    public static final class ReadSequenceExecutor
    extends AsyncMultiExecutor {
        private final BatchSequenceListener listener;

        public ReadSequenceExecutor(AsyncCluster cluster, BatchPolicy policy, BatchSequenceListener listener, List<BatchRead> records) {
            this.listener = listener;
            List<BatchNode> batchNodes = BatchNode.generateList((Cluster)cluster, policy, records);
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                if (!batchNode.node.hasBatchIndex()) {
                    throw new AerospikeException(4, "Requested command requires a server that supports new batch index protocol.");
                }
                tasks[count++] = new ReadSequenceCommand(this, cluster, batchNode, policy, listener, records);
            }
            this.execute(tasks, policy.maxConcurrentThreads);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ReadListCommand
    extends AsyncMultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final List<BatchRead> records;

        public ReadListCommand(AsyncMultiExecutor parent, AsyncCluster cluster, BatchNode batch, BatchPolicy policy, List<BatchRead> records) {
            super(parent, cluster, (AsyncNode)batch.node, policy, false);
            this.batch = batch;
            this.policy = policy;
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) {
            BatchRead record = this.records.get(this.batchIndex);
            if (Arrays.equals(key.digest, record.key.digest)) {
                if (this.resultCode == 0) {
                    record.record = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
        }
    }

    public static final class ReadListExecutor
    extends AsyncMultiExecutor {
        private final BatchListListener listener;
        private final List<BatchRead> records;

        public ReadListExecutor(AsyncCluster cluster, BatchPolicy policy, BatchListListener listener, List<BatchRead> records) {
            this.listener = listener;
            this.records = records;
            List<BatchNode> batchNodes = BatchNode.generateList((Cluster)cluster, policy, records);
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                if (!batchNode.node.hasBatchIndex()) {
                    throw new AerospikeException(4, "Requested command requires a server that supports new batch index protocol.");
                }
                tasks[count++] = new ReadListCommand((AsyncMultiExecutor)this, cluster, batchNode, policy, records);
            }
            this.execute(tasks, policy.maxConcurrentThreads);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }
}

