/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AsyncCommand
extends Command
implements Runnable {
    private static final int IN_PROGRESS = 0;
    private static final int TIMEOUT_DELAY = 1;
    private static final int COMPLETE = 2;
    protected AsyncConnection conn;
    protected ByteBuffer byteBuffer;
    protected AsyncNode node;
    protected final AsyncCluster cluster;
    protected final Policy policy;
    private final AtomicInteger state = new AtomicInteger();
    private long limit;
    private int iterations;
    protected boolean inAuthenticate;
    protected boolean inHeader = true;

    public AsyncCommand(AsyncCluster cluster, Policy policy) {
        this.cluster = cluster;
        this.policy = policy;
    }

    public AsyncCommand(AsyncCommand other) {
        this.cluster = other.cluster;
        this.policy = other.policy;
        this.byteBuffer = other.byteBuffer;
        this.limit = other.limit;
        this.iterations = other.iterations + 1;
        this.sequence = other.sequence;
    }

    public final void execute() {
        if (this.policy.timeout > 0) {
            this.limit = System.currentTimeMillis() + (long)this.policy.timeout;
        }
        this.byteBuffer = this.cluster.getByteBuffer();
        this.executeCommand();
    }

    private void executeCommand() {
        try {
            this.node = (AsyncNode)this.getNode();
            this.conn = this.node.getAsyncConnection(this.byteBuffer);
            if (this.conn == null) {
                this.conn = new AsyncConnection(this.node.getAddress(), this.cluster);
                if (this.cluster.getUser() != null) {
                    this.inAuthenticate = true;
                    this.dataBuffer = ThreadLocalData.getBuffer();
                    AdminCommand command = new AdminCommand(this.dataBuffer);
                    this.dataOffset = command.setAuthenticate(this.cluster.getUser(), this.cluster.getPassword());
                    this.byteBuffer.clear();
                    this.byteBuffer.put(this.dataBuffer, 0, this.dataOffset);
                    this.byteBuffer.flip();
                    this.conn.execute(this);
                    return;
                }
            }
            this.writeCommand();
            this.conn.execute(this);
        }
        catch (AerospikeException.Connection aec) {
            if (this.iterations < this.policy.maxRetries && (this.policy.retryOnTimeout || this.limit == 0L || System.currentTimeMillis() < this.limit)) {
                this.closeConnection();
                ++this.iterations;
                if (this.policy.timeout > 0 && this.policy.retryOnTimeout) {
                    this.limit = System.currentTimeMillis() + (long)this.policy.timeout;
                }
                this.executeCommand();
            }
            this.cleanup();
            throw aec;
        }
        catch (RuntimeException re) {
            this.cleanup();
            throw re;
        }
    }

    protected final void writeCommand() {
        this.writeBuffer();
        if (this.dataOffset > this.byteBuffer.capacity()) {
            this.byteBuffer = ByteBuffer.allocateDirect(this.dataOffset);
        }
        this.byteBuffer.clear();
        this.byteBuffer.put(this.dataBuffer, 0, this.dataOffset);
        this.byteBuffer.flip();
    }

    protected final void processAuthenticate() {
        this.inAuthenticate = false;
        this.inHeader = true;
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
        this.writeCommand();
        this.conn.setWriteable();
    }

    protected final void write() throws IOException {
        this.conn.write(this.byteBuffer);
    }

    protected final boolean checkTimeout() {
        int status = this.state.get();
        if (status == 2) {
            return false;
        }
        if (this.limit > 0L && System.currentTimeMillis() > this.limit && this.conn.allowTimeout()) {
            if (this.policy.timeoutDelay > 0) {
                if (status == 0) {
                    if (this.state.compareAndSet(0, 1)) {
                        this.limit = System.currentTimeMillis() + (long)this.policy.timeoutDelay;
                        this.onFailure(new AerospikeException.Timeout(this.node, this.policy.timeout, this.iterations + 1, 0, 0));
                        return true;
                    }
                } else if (this.state.compareAndSet(1, 2)) {
                    this.cleanup();
                }
            } else if (this.state.compareAndSet(0, 2)) {
                AsyncCommand command;
                if (this.iterations < this.policy.maxRetries && this.policy.retryOnTimeout && (command = this.cloneCommand()) != null) {
                    this.closeConnection();
                    command.limit = System.currentTimeMillis() + (long)this.policy.timeout;
                    try {
                        command.executeCommand();
                    }
                    catch (Exception e) {
                        this.onFailure(new AerospikeException.Timeout(this.node, this.policy.timeout, this.iterations + 1, 0, 0));
                    }
                    return false;
                }
                this.cleanup();
                this.onFailure(new AerospikeException.Timeout(this.node, this.policy.timeout, this.iterations + 1, 0, 0));
            }
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.read();
            if (this.state.get() != 2) {
                this.conn.setReadable();
            }
        }
        catch (AerospikeException.Connection ac) {
            this.onNetworkError(ac);
        }
        catch (AerospikeException ae) {
            this.onApplicationError(ae);
        }
        catch (IOException ioe) {
            this.onNetworkError(new AerospikeException(ioe));
        }
        catch (Exception e) {
            this.onApplicationError(new AerospikeException(e));
        }
    }

    protected final void finish() {
        if (this.state.compareAndSet(0, 2)) {
            this.conn.unregister();
            this.node.putAsyncConnection(this.conn);
            this.cluster.putByteBuffer(this.byteBuffer);
            try {
                this.onSuccess();
            }
            catch (AerospikeException ae) {
                this.onFailure(ae);
            }
            catch (Exception e) {
                this.onFailure(new AerospikeException(e));
            }
        } else if (this.state.compareAndSet(1, 2)) {
            this.conn.unregister();
            this.node.putAsyncConnection(this.conn);
            this.cluster.putByteBuffer(this.byteBuffer);
        }
    }

    protected final void onNetworkError(AerospikeException ae) {
        if (this.state.compareAndSet(0, 2)) {
            AsyncCommand command;
            if (this.iterations < this.policy.maxRetries && (this.policy.retryOnTimeout || this.limit == 0L || System.currentTimeMillis() < this.limit) && (command = this.cloneCommand()) != null) {
                this.closeConnection();
                if (this.policy.timeout > 0 && this.policy.retryOnTimeout) {
                    command.limit = System.currentTimeMillis() + (long)this.policy.timeout;
                }
                try {
                    command.executeCommand();
                }
                catch (Exception e) {
                    this.onFailure(ae);
                }
                return;
            }
            this.cleanup();
            this.onFailure(ae);
        } else if (this.state.compareAndSet(1, 2)) {
            this.cleanup();
        }
    }

    protected final void onApplicationError(AerospikeException ae) {
        boolean notify = this.state.compareAndSet(0, 2);
        if (notify || this.state.compareAndSet(1, 2)) {
            if (ae.keepConnection()) {
                this.conn.unregister();
                this.node.putAsyncConnection(this.conn);
                this.cluster.putByteBuffer(this.byteBuffer);
            } else {
                this.cleanup();
            }
            if (notify) {
                this.onFailure(ae);
            }
        }
    }

    private void cleanup() {
        this.closeConnection();
        this.cluster.putByteBuffer(this.byteBuffer);
    }

    private void closeConnection() {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    protected abstract AsyncCommand cloneCommand();

    protected abstract void read() throws AerospikeException, IOException;

    protected abstract void onSuccess();

    protected abstract void onFailure(AerospikeException var1);
}

