/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.policy.WritePolicy;
import java.nio.ByteBuffer;

public final class AsyncDelete
extends AsyncSingleCommand {
    private final WritePolicy writePolicy;
    private final DeleteListener listener;
    private final Key key;
    private final Partition partition;
    private boolean existed;

    public AsyncDelete(AsyncCluster cluster, WritePolicy writePolicy, DeleteListener listener, Key key) {
        super(cluster, writePolicy);
        this.writePolicy = writePolicy;
        this.listener = listener;
        this.key = key;
        this.partition = new Partition(key);
    }

    public AsyncDelete(AsyncDelete other) {
        super(other);
        this.writePolicy = other.writePolicy;
        this.listener = other.listener;
        this.key = other.key;
        this.partition = other.partition;
    }

    @Override
    protected AsyncCommand cloneCommand() {
        return new AsyncDelete(this);
    }

    @Override
    protected void writeBuffer() {
        this.setDelete(this.writePolicy, this.key);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode == 0) {
            this.existed = true;
        } else if (resultCode == 2) {
            this.existed = false;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.existed);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

