/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.HashMap;

public abstract class AsyncMultiCommand
extends AsyncCommand {
    private final AsyncMultiExecutor parent;
    protected final AsyncNode node;
    protected byte[] receiveBuffer;
    protected int receiveSize;
    protected int receiveOffset;
    protected int resultCode;
    protected int generation;
    protected int expiration;
    protected int batchIndex;
    protected int fieldCount;
    protected int opCount;
    private final boolean stopOnNotFound;
    protected volatile boolean valid = true;

    public AsyncMultiCommand(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, Policy policy, boolean stopOnNotFound) {
        super(cluster, policy);
        this.parent = parent;
        this.node = node;
        this.stopOnNotFound = stopOnNotFound;
    }

    @Override
    protected final AsyncCommand cloneCommand() {
        return null;
    }

    @Override
    protected final Node getNode() {
        return this.node;
    }

    @Override
    protected final void read() throws AerospikeException, IOException {
        int groups = 0;
        while (true) {
            if (this.inHeader) {
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
                this.byteBuffer.position(0);
                this.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
                if (this.receiveSize <= 0) {
                    return;
                }
                if (this.receiveBuffer == null || this.receiveSize > this.receiveBuffer.length) {
                    this.receiveBuffer = new byte[this.receiveSize];
                }
                this.byteBuffer.clear();
                if (this.receiveSize < this.byteBuffer.capacity()) {
                    this.byteBuffer.limit(this.receiveSize);
                }
                this.inHeader = false;
                if (groups > 0 && this.receiveSize != 22) {
                    return;
                }
            }
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            if (this.inAuthenticate) {
                this.processAuthenticate();
                return;
            }
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.receiveBuffer, this.receiveOffset, this.byteBuffer.limit());
            this.receiveOffset += this.byteBuffer.limit();
            this.byteBuffer.clear();
            if (this.receiveOffset >= this.receiveSize) {
                if (this.parseGroup()) {
                    this.finish();
                    return;
                }
                this.byteBuffer.limit(8);
                this.receiveOffset = 0;
                this.inHeader = true;
                ++groups;
                continue;
            }
            int remaining = this.receiveSize - this.receiveOffset;
            if (remaining >= this.byteBuffer.capacity()) continue;
            this.byteBuffer.limit(remaining);
        }
    }

    private final boolean parseGroup() throws AerospikeException {
        this.receiveOffset = 0;
        while (this.receiveOffset < this.receiveSize) {
            this.resultCode = this.receiveBuffer[this.receiveOffset + 5] & 0xFF;
            if (this.resultCode != 0) {
                if (this.resultCode == 2) {
                    if (this.stopOnNotFound) {
                        return true;
                    }
                } else {
                    throw new AerospikeException(this.resultCode);
                }
            }
            if ((this.receiveBuffer[this.receiveOffset + 3] & 1) != 0) {
                return true;
            }
            this.generation = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset + 6);
            this.expiration = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset + 10);
            this.batchIndex = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset + 14);
            this.fieldCount = Buffer.bytesToShort(this.receiveBuffer, this.receiveOffset + 18);
            this.opCount = Buffer.bytesToShort(this.receiveBuffer, this.receiveOffset + 20);
            this.receiveOffset += 22;
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            Key key = this.parseKey();
            this.parseRow(key);
        }
        return false;
    }

    protected final Key parseKey() throws AerospikeException {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        block6: for (int i = 0; i < this.fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
            this.receiveOffset += 4;
            byte fieldtype = this.receiveBuffer[this.receiveOffset++];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.receiveBuffer, this.receiveOffset, digest, 0, size);
                    this.receiveOffset += size;
                    continue block6;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.receiveBuffer, this.receiveOffset, size);
                    this.receiveOffset += size;
                    continue block6;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.receiveBuffer, this.receiveOffset, size);
                    this.receiveOffset += size;
                    continue block6;
                }
                case 2: {
                    byte type = this.receiveBuffer[this.receiveOffset++];
                    userKey = Buffer.bytesToKeyValue(type, this.receiveBuffer, this.receiveOffset, --size);
                    this.receiveOffset += size;
                }
            }
        }
        return new Key(namespace, digest, setName, userKey);
    }

    protected Record parseRecord() throws AerospikeException {
        HashMap<String, Object> bins = null;
        for (int i = 0; i < this.opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.receiveBuffer, this.receiveOffset);
            byte particleType = this.receiveBuffer[this.receiveOffset + 5];
            byte nameSize = this.receiveBuffer[this.receiveOffset + 7];
            String name = Buffer.utf8ToString(this.receiveBuffer, this.receiveOffset + 8, nameSize);
            this.receiveOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.receiveBuffer, this.receiveOffset, particleBytesSize);
            this.receiveOffset += particleBytesSize;
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            bins.put(name, value);
        }
        return new Record(bins, this.generation, this.expiration);
    }

    protected void stop() {
        this.valid = false;
    }

    @Override
    protected void onSuccess() {
        this.parent.childSuccess();
    }

    @Override
    protected void onFailure(AerospikeException e) {
        this.parent.childFailure(e);
    }

    protected abstract void parseRow(Key var1) throws AerospikeException;
}

