/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.Map;

public final class AsyncOperate
extends AsyncRead {
    private final WritePolicy writePolicy;
    private final Operation[] operations;

    public AsyncOperate(AsyncCluster cluster, WritePolicy writePolicy, RecordListener listener, Key key, Operation[] operations) {
        super(cluster, writePolicy, listener, key, null);
        this.writePolicy = writePolicy;
        this.operations = operations;
    }

    public AsyncOperate(AsyncOperate other) {
        super(other);
        this.writePolicy = other.writePolicy;
        this.operations = other.operations;
    }

    @Override
    protected AsyncCommand cloneCommand() {
        return new AsyncOperate(this);
    }

    @Override
    protected void writeBuffer() {
        this.setOperate(this.writePolicy, this.key, this.operations);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void addBin(Map<String, Object> bins, String name, Object value) {
        if (bins.containsKey(name)) {
            Object prev = bins.get(name);
            if (prev instanceof OpResults) {
                OpResults list = (OpResults)prev;
                list.add(value);
            } else {
                OpResults list = new OpResults();
                list.add(prev);
                list.add(value);
                bins.put(name, list);
            }
        } else {
            bins.put(name, value);
        }
    }

    private static class OpResults
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private OpResults() {
        }
    }
}

