/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.async.AsyncQuery;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Statement;

public final class AsyncQueryExecutor
extends AsyncMultiExecutor {
    private final RecordSequenceListener listener;

    public AsyncQueryExecutor(AsyncCluster cluster, QueryPolicy policy, RecordSequenceListener listener, Statement statement) throws AerospikeException {
        this.listener = listener;
        statement.prepare(true);
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Query failed because cluster is empty.");
        }
        AsyncMultiCommand[] tasks = new AsyncQuery[nodes.length];
        int count = 0;
        for (Node node : nodes) {
            tasks[count++] = new AsyncQuery(this, cluster, (AsyncNode)node, policy, listener, statement);
        }
        this.execute(tasks, policy.maxConcurrentNodes);
    }

    @Override
    protected void onSuccess() {
        this.listener.onSuccess();
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.listener.onFailure(ae);
    }
}

