/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;
import java.nio.ByteBuffer;

public class AsyncReadHeader
extends AsyncSingleCommand {
    private final RecordListener listener;
    private final Key key;
    private final Partition partition;
    private Record record;

    public AsyncReadHeader(AsyncCluster cluster, Policy policy, RecordListener listener, Key key) {
        super(cluster, policy);
        this.listener = listener;
        this.key = key;
        this.partition = new Partition(key);
    }

    public AsyncReadHeader(AsyncReadHeader other) {
        super(other);
        this.listener = other.listener;
        this.key = other.key;
        this.partition = other.partition;
    }

    @Override
    protected AsyncCommand cloneCommand() {
        return new AsyncReadHeader(this);
    }

    @Override
    protected void writeBuffer() {
        this.setReadHeader(this.policy, this.key);
    }

    @Override
    protected Node getNode() {
        return this.getReadNode(this.cluster, this.partition, this.policy.replica);
    }

    @Override
    protected final void parseResult(ByteBuffer byteBuffer) {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode == 0) {
            int generation = byteBuffer.getInt(6);
            int expiration = byteBuffer.getInt(10);
            this.record = new Record(null, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected final void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected final void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

