/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.WritePolicy;
import java.nio.ByteBuffer;

public final class AsyncTouch
extends AsyncSingleCommand {
    private final WritePolicy writePolicy;
    private final WriteListener listener;
    private final Key key;
    private final Partition partition;

    public AsyncTouch(AsyncCluster cluster, WritePolicy writePolicy, WriteListener listener, Key key) {
        super(cluster, writePolicy);
        this.writePolicy = writePolicy;
        this.listener = listener;
        this.key = key;
        this.partition = new Partition(key);
    }

    public AsyncTouch(AsyncTouch other) {
        super(other);
        this.writePolicy = other.writePolicy;
        this.listener = other.listener;
        this.key = other.key;
        this.partition = other.partition;
    }

    @Override
    protected AsyncCommand cloneCommand() {
        return new AsyncTouch(this);
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.writePolicy, this.key);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

