/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.WritePolicy;
import java.nio.ByteBuffer;

public final class AsyncWrite
extends AsyncSingleCommand {
    private final WritePolicy writePolicy;
    private final WriteListener listener;
    private final Key key;
    private final Partition partition;
    private final Bin[] bins;
    private final Operation.Type operation;

    public AsyncWrite(AsyncCluster cluster, WritePolicy writePolicy, WriteListener listener, Key key, Bin[] bins, Operation.Type operation) {
        super(cluster, writePolicy);
        this.writePolicy = writePolicy;
        this.listener = listener;
        this.key = key;
        this.partition = new Partition(key);
        this.bins = bins;
        this.operation = operation;
    }

    public AsyncWrite(AsyncWrite other) {
        super(other);
        this.writePolicy = other.writePolicy;
        this.listener = other.listener;
        this.key = other.key;
        this.partition = other.partition;
        this.bins = other.bins;
        this.operation = other.operation;
    }

    @Override
    protected AsyncCommand cloneCommand() {
        return new AsyncWrite(this);
    }

    @Override
    protected void writeBuffer() {
        this.setWrite(this.writePolicy, this.operation, this.key, this.bins);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

