/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Pool;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class Connection
implements Closeable {
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;
    protected final Pool pool;
    private final long maxSocketIdleMillis;
    private volatile long lastUsed;

    public Connection(InetSocketAddress address, int timeoutMillis) throws AerospikeException.Connection {
        this(null, null, address, timeoutMillis, 55000, null);
    }

    public Connection(TlsPolicy policy, String tlsName, InetSocketAddress address, int timeoutMillis, int maxSocketIdleMillis, Pool pool) throws AerospikeException.Connection {
        block15: {
            this.maxSocketIdleMillis = maxSocketIdleMillis;
            this.pool = pool;
            try {
                if (policy == null) {
                    this.socket = new Socket();
                    try {
                        this.socket.setTcpNoDelay(true);
                        if (timeoutMillis > 0) {
                            this.socket.setSoTimeout(timeoutMillis);
                        } else {
                            timeoutMillis = 2000;
                        }
                        this.socket.connect(address, timeoutMillis);
                        this.in = this.socket.getInputStream();
                        this.out = this.socket.getOutputStream();
                        this.lastUsed = System.currentTimeMillis();
                        break block15;
                    }
                    catch (Exception e) {
                        this.socket.close();
                        throw e;
                    }
                }
                SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket sslSocket = (SSLSocket)sslsocketfactory.createSocket(address.getAddress(), address.getPort());
                this.socket = sslSocket;
                try {
                    this.socket.setTcpNoDelay(true);
                    if (timeoutMillis > 0) {
                        this.socket.setSoTimeout(timeoutMillis);
                    } else {
                        timeoutMillis = 2000;
                    }
                    if (policy.protocols != null) {
                        sslSocket.setEnabledProtocols(policy.protocols);
                    }
                    if (policy.ciphers != null) {
                        sslSocket.setEnabledCipherSuites(policy.ciphers);
                    }
                    if (!policy.encryptOnly) {
                        Connection.validateServerCertificateName(policy, sslSocket, tlsName);
                    }
                    this.in = this.socket.getInputStream();
                    this.out = this.socket.getOutputStream();
                    this.lastUsed = System.currentTimeMillis();
                }
                catch (Exception e) {
                    this.socket.close();
                    throw e;
                }
            }
            catch (AerospikeException.Connection ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AerospikeException.Connection(e);
            }
        }
    }

    private static void validateServerCertificateName(TlsPolicy policy, SSLSocket sslSocket, String tlsName) throws Exception {
        if (tlsName == null) {
            throw new AerospikeException.Connection("Invalid TLS name: null");
        }
        sslSocket.setUseClientMode(true);
        sslSocket.startHandshake();
        X509Certificate cert = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
        if (policy.revokeCertificates != null) {
            BigInteger serialNumber = cert.getSerialNumber();
            for (BigInteger sn : policy.revokeCertificates) {
                if (!sn.equals(serialNumber)) continue;
                throw new AerospikeException.Connection("Invalid certificate serial number: " + sn);
            }
        }
        String subject = cert.getSubjectX500Principal().getName("RFC2253");
        LdapName ldapName = new LdapName(subject);
        for (Rdn rdn : ldapName.getRdns()) {
            String certName;
            Attribute cn = rdn.toAttributes().get("CN");
            if (cn == null || !(certName = (String)cn.get()).equals(tlsName)) continue;
            return;
        }
        Collection<List<?>> allNames = cert.getSubjectAlternativeNames();
        if (allNames != null) {
            for (List<?> list : allNames) {
                int type = (Integer)list.get(0);
                if (type != 2 || !list.get(1).equals(tlsName)) continue;
                return;
            }
        }
        throw new AerospikeException.Connection("Invalid TLS name: " + tlsName);
    }

    public void write(byte[] buffer, int length) throws IOException {
        int len;
        int max = length;
        for (int pos = 0; pos < max; pos += len) {
            len = max - pos;
            if (len > 8192) {
                len = 8192;
            }
            this.out.write(buffer, pos, len);
        }
    }

    public void readFully(byte[] buffer, int length) throws IOException {
        int count;
        for (int pos = 0; pos < length; pos += count) {
            count = this.in.read(buffer, pos, length - pos);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public boolean isValid() {
        return System.currentTimeMillis() - this.lastUsed <= this.maxSocketIdleMillis;
    }

    public boolean isClosed() {
        return this.lastUsed == 0L;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public void close() {
        block2: {
            this.lastUsed = 0L;
            try {
                this.in.close();
                this.out.close();
                this.socket.close();
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) break block2;
                Log.debug("Error closing socket: " + Util.getErrorMessage(e));
            }
        }
    }
}

