/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.PartitionParser;
import com.aerospike.client.cluster.Peer;
import com.aerospike.client.cluster.PeerParser;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.Pool;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;

public class Node
implements Closeable {
    public static final int PARTITIONS = 4096;
    public static final int HAS_GEO = 1;
    public static final int HAS_DOUBLE = 2;
    public static final int HAS_BATCH_INDEX = 4;
    public static final int HAS_REPLICAS_ALL = 8;
    public static final int HAS_PEERS = 16;
    protected final Cluster cluster;
    private final String name;
    private final Host host;
    protected final List<Host> aliases;
    protected final InetSocketAddress address;
    private final Pool[] connectionPools;
    private Connection tendConnection;
    protected int connectionIter;
    protected int peersGeneration;
    protected int partitionGeneration;
    protected int peersCount;
    protected int referenceCount;
    protected int failures;
    private final int features;
    protected boolean partitionChanged;
    protected volatile boolean active;

    public Node(Cluster cluster, NodeValidator nv) {
        this.cluster = cluster;
        this.name = nv.name;
        this.aliases = nv.aliases;
        this.host = nv.primaryHost;
        this.address = nv.primaryAddress;
        this.tendConnection = nv.conn;
        this.features = nv.features;
        this.connectionPools = new Pool[cluster.connPoolsPerNode];
        int max = cluster.connectionQueueSize / cluster.connPoolsPerNode;
        int rem = cluster.connectionQueueSize - max * cluster.connPoolsPerNode;
        for (int i = 0; i < this.connectionPools.length; ++i) {
            int capacity = i < rem ? max + 1 : max;
            this.connectionPools[i] = new Pool(capacity);
        }
        this.peersGeneration = -1;
        this.partitionGeneration = -1;
        this.active = true;
    }

    public final void refresh(Peers peers) {
        if (!this.active) {
            return;
        }
        try {
            if (this.tendConnection.isClosed()) {
                this.tendConnection = new Connection(this.cluster.tlsPolicy, this.host.tlsName, this.address, this.cluster.getConnectionTimeout(), this.cluster.maxSocketIdleMillis, null);
                if (this.cluster.user != null) {
                    try {
                        AdminCommand command = new AdminCommand(ThreadLocalData.getBuffer());
                        command.authenticate(this.tendConnection, this.cluster.user, this.cluster.password);
                    }
                    catch (AerospikeException ae) {
                        this.tendConnection.close();
                        throw ae;
                    }
                    catch (Exception e) {
                        this.tendConnection.close();
                        throw new AerospikeException(e);
                    }
                }
            }
            if (peers.usePeers) {
                HashMap<String, String> infoMap = Info.request(this.tendConnection, "node", "peers-generation", "partition-generation");
                this.verifyNodeName(infoMap);
                this.verifyPeersGeneration(infoMap, peers);
                this.verifyPartitionGeneration(infoMap);
            } else {
                String[] stringArray;
                if (this.cluster.useServicesAlternate) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "node";
                    stringArray2[1] = "partition-generation";
                    stringArray = stringArray2;
                    stringArray2[2] = "services-alternate";
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = "node";
                    stringArray3[1] = "partition-generation";
                    stringArray = stringArray3;
                    stringArray3[2] = "services";
                }
                String[] commands = stringArray;
                HashMap<String, String> infoMap = Info.request(this.tendConnection, commands);
                this.verifyNodeName(infoMap);
                this.verifyPartitionGeneration(infoMap);
                this.addFriends(infoMap, peers);
            }
            ++peers.refreshCount;
            this.failures = 0;
        }
        catch (Exception e) {
            peers.genChanged = true;
            this.refreshFailed(e);
        }
    }

    private final void verifyNodeName(HashMap<String, String> infoMap) {
        String infoName = infoMap.get("node");
        if (infoName == null || infoName.length() == 0) {
            throw new AerospikeException.Parse("Node name is empty");
        }
        if (!this.name.equals(infoName)) {
            this.active = false;
            throw new AerospikeException("Node name has changed. Old=" + this.name + " New=" + infoName);
        }
    }

    private final void verifyPeersGeneration(HashMap<String, String> infoMap, Peers peers) {
        String genString = infoMap.get("peers-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("peers-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.peersGeneration != gen) {
            peers.genChanged = true;
        }
    }

    private final void verifyPartitionGeneration(HashMap<String, String> infoMap) {
        String genString = infoMap.get("partition-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("partition-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.partitionGeneration != gen) {
            this.partitionChanged = true;
        }
    }

    private final void addFriends(HashMap<String, String> infoMap, Peers peers) throws AerospikeException {
        String command = this.cluster.useServicesAlternate ? "services-alternate" : "services";
        String friendString = infoMap.get(command);
        if (friendString == null || friendString.length() == 0) {
            this.peersCount = 0;
            return;
        }
        String[] friendNames = friendString.split(";");
        this.peersCount = friendNames.length;
        for (String friend : friendNames) {
            int port;
            Host host;
            Node node;
            String alternativeHost;
            String[] friendInfo = friend.split(":");
            String hostname = friendInfo[0];
            if (this.cluster.ipMap != null && (alternativeHost = this.cluster.ipMap.get(hostname)) != null) {
                hostname = alternativeHost;
            }
            if ((node = this.cluster.aliases.get(host = new Host(hostname, port = Integer.parseInt(friendInfo[1])))) == null) {
                if (peers.hosts.contains(host)) continue;
                this.prepareFriend(host, peers);
                continue;
            }
            ++node.referenceCount;
        }
    }

    private final boolean prepareFriend(Host host, Peers peers) {
        try {
            NodeValidator nv = new NodeValidator();
            nv.validateNode(this.cluster, host);
            Node node = peers.nodes.get(nv.name);
            if (node != null) {
                nv.conn.close();
                peers.hosts.add(host);
                node.aliases.add(host);
                return true;
            }
            node = this.cluster.nodesMap.get(nv.name);
            if (node != null) {
                nv.conn.close();
                peers.hosts.add(host);
                node.aliases.add(host);
                ++node.referenceCount;
                this.cluster.aliases.put(host, node);
                return true;
            }
            node = this.cluster.createNode(nv);
            peers.hosts.add(host);
            peers.nodes.put(nv.name, node);
            return true;
        }
        catch (Exception e) {
            if (Log.warnEnabled()) {
                Log.warn("Add node " + host + " failed: " + Util.getErrorMessage(e));
            }
            return false;
        }
    }

    protected final void refreshPeers(Peers peers) {
        if (this.failures > 0 || !this.active) {
            return;
        }
        try {
            if (Log.debugEnabled()) {
                Log.debug("Update peers for node " + this);
            }
            PeerParser parser = new PeerParser(this.cluster, this.tendConnection, peers.peers);
            this.peersGeneration = parser.generation;
            this.peersCount = peers.peers.size();
            block4: for (Peer peer : peers.peers) {
                if (Node.findPeerNode(this.cluster, peers, peer.nodeName)) continue;
                for (Host host : peer.hosts) {
                    try {
                        NodeValidator nv = new NodeValidator();
                        nv.validateNode(this.cluster, host);
                        if (!peer.nodeName.equals(nv.name)) {
                            if (Log.warnEnabled()) {
                                Log.warn("Peer node " + peer.nodeName + " is different than actual node " + nv.name + " for host " + host);
                            }
                            if (Node.findPeerNode(this.cluster, peers, nv.name)) {
                                nv.conn.close();
                                continue block4;
                            }
                        }
                        Node node = this.cluster.createNode(nv);
                        peers.nodes.put(nv.name, node);
                        continue block4;
                    }
                    catch (Exception e) {
                        if (!Log.warnEnabled()) continue;
                        Log.warn("Add node " + host + " failed: " + Util.getErrorMessage(e));
                    }
                }
            }
            ++peers.refreshCount;
        }
        catch (Exception e) {
            this.refreshFailed(e);
        }
    }

    private static boolean findPeerNode(Cluster cluster, Peers peers, String nodeName) {
        Node node = cluster.nodesMap.get(nodeName);
        if (node != null) {
            ++node.referenceCount;
            return true;
        }
        node = peers.nodes.get(nodeName);
        if (node != null) {
            ++node.referenceCount;
            return true;
        }
        return false;
    }

    protected final void refreshPartitions(Peers peers) {
        if (this.failures > 0 || !this.active || this.peersCount == 0 && peers.refreshCount > 1) {
            return;
        }
        try {
            PartitionParser parser;
            if (Log.debugEnabled()) {
                Log.debug("Update partition map for node " + this);
            }
            if ((parser = new PartitionParser(this.tendConnection, this, this.cluster.partitionMap, 4096, this.cluster.requestProleReplicas)).isPartitionMapCopied()) {
                this.cluster.partitionMap = parser.getPartitionMap();
            }
            this.partitionGeneration = parser.getGeneration();
        }
        catch (Exception e) {
            this.refreshFailed(e);
        }
    }

    private final void refreshFailed(Exception e) {
        ++this.failures;
        if (!this.tendConnection.isClosed()) {
            this.tendConnection.close();
        }
        if (this.cluster.tendValid && Log.warnEnabled()) {
            Log.warn("Node " + this + " refresh failed: " + Util.getErrorMessage(e));
        }
    }

    public final Connection getConnection(int timeoutMillis) throws AerospikeException {
        boolean backward;
        int initialIndex;
        int max = this.cluster.connPoolsPerNode;
        if (max == 1) {
            initialIndex = 0;
            backward = false;
        } else {
            int iter;
            if ((initialIndex = (iter = this.connectionIter++) % max) < 0) {
                initialIndex += max;
            }
            backward = true;
        }
        Pool pool = this.connectionPools[initialIndex];
        int queueIndex = initialIndex;
        while (true) {
            Connection conn;
            if ((conn = pool.queue.poll()) != null) {
                if (conn.isValid()) {
                    try {
                        conn.setTimeout(timeoutMillis);
                        return conn;
                    }
                    catch (Exception e) {
                        this.closeConnection(conn);
                        throw new AerospikeException.Connection(e);
                    }
                }
                this.closeConnection(conn);
                continue;
            }
            if (pool.total.getAndIncrement() < pool.capacity) {
                try {
                    conn = new Connection(this.cluster.tlsPolicy, this.host.tlsName, this.address, timeoutMillis, this.cluster.maxSocketIdleMillis, pool);
                }
                catch (RuntimeException re) {
                    pool.total.getAndDecrement();
                    throw re;
                }
                if (this.cluster.user != null) {
                    try {
                        AdminCommand command = new AdminCommand(ThreadLocalData.getBuffer());
                        command.authenticate(conn, this.cluster.user, this.cluster.password);
                    }
                    catch (AerospikeException ae) {
                        this.closeConnection(conn);
                        throw ae;
                    }
                    catch (Exception e) {
                        this.closeConnection(conn);
                        throw new AerospikeException(e);
                    }
                }
                return conn;
            }
            pool.total.getAndDecrement();
            if (backward) {
                if (queueIndex > 0) {
                    --queueIndex;
                } else {
                    queueIndex = initialIndex;
                    if (++queueIndex >= max) break;
                    backward = false;
                }
            } else if (++queueIndex >= max) break;
            pool = this.connectionPools[queueIndex];
        }
        throw new AerospikeException.Connection(-7, "Node " + this + " max connections " + this.cluster.connectionQueueSize + " would be exceeded.");
    }

    public final void putConnection(Connection conn) {
        conn.updateLastUsed();
        if (!this.active || !conn.pool.queue.offer(conn)) {
            this.closeConnection(conn);
        }
    }

    public final void closeConnection(Connection conn) {
        conn.pool.total.getAndDecrement();
        conn.close();
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getName() {
        return this.name;
    }

    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final boolean useNewBatch(BatchPolicy policy) {
        return !policy.useBatchDirect && this.hasBatchIndex();
    }

    public final boolean hasBatchIndex() {
        return (this.features & 4) != 0;
    }

    public final boolean hasDouble() {
        return (this.features & 2) != 0;
    }

    public final boolean hasReplicasAll() {
        return (this.features & 8) != 0;
    }

    public final boolean hasPeers() {
        return (this.features & 0x10) != 0;
    }

    @Override
    public final void close() {
        this.active = false;
        this.closeConnections();
    }

    public final String toString() {
        return this.name + ' ' + this.host;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        Node other = (Node)obj;
        return this.name.equals(other.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            this.closeConnections();
        }
        finally {
            super.finalize();
        }
    }

    protected void closeConnections() {
        Connection conn = this.tendConnection;
        conn.close();
        for (Pool pool : this.connectionPools) {
            while ((conn = pool.queue.poll()) != null) {
                conn.close();
            }
        }
    }
}

