/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class Batch {

    public static final class ExistsArrayDirect
    extends MultiCommand {
        private final BatchNode.BatchNamespace batch;
        private final Policy policy;
        private final Key[] keys;
        private final boolean[] existsArray;
        private int index;

        public ExistsArrayDirect(Node node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, boolean[] existsArray) {
            super(node, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected Policy getPolicy() {
            return this.policy;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchReadDirect(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            int offset = this.batch.offsets[this.index++];
            if (!Arrays.equals(key.digest, this.keys[offset].digest)) {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
            }
            this.existsArray[offset] = this.resultCode == 0;
        }
    }

    public static final class ExistsArrayCommand
    extends MultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(BatchNode batch, BatchPolicy policy, Key[] keys, boolean[] existsArray) {
            super(batch.node, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected Policy getPolicy() {
            return this.policy;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            if (!Arrays.equals(key.digest, this.keys[this.batchIndex].digest)) {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }
    }

    public static final class GetArrayDirect
    extends MultiCommand {
        private final BatchNode.BatchNamespace batch;
        private final Policy policy;
        private final Key[] keys;
        private final String[] binNames;
        private final Record[] records;
        private final int readAttr;
        private int index;

        public GetArrayDirect(Node node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, String[] binNames, Record[] records, int readAttr) {
            super(node, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.binNames = binNames;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected Policy getPolicy() {
            return this.policy;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchReadDirect(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            int offset = this.batch.offsets[this.index++];
            if (Arrays.equals(key.digest, this.keys[offset].digest)) {
                if (this.resultCode == 0) {
                    this.records[offset] = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
            }
        }
    }

    public static final class GetArrayCommand
    extends MultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final Key[] keys;
        private final String[] binNames;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, Record[] records, int readAttr) {
            super(batch.node, false);
            this.batch = batch;
            this.policy = policy;
            this.keys = keys;
            this.binNames = binNames;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected Policy getPolicy() {
            return this.policy;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            if (Arrays.equals(key.digest, this.keys[this.batchIndex].digest)) {
                if (this.resultCode == 0) {
                    this.records[this.batchIndex] = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
        }
    }

    public static final class ReadListCommand
    extends MultiCommand {
        private final BatchNode batch;
        private final BatchPolicy policy;
        private final List<BatchRead> records;

        public ReadListCommand(BatchNode batch, BatchPolicy policy, List<BatchRead> records) {
            super(batch.node, false);
            this.batch = batch;
            this.policy = policy;
            this.records = records;
        }

        @Override
        protected Policy getPolicy() {
            return this.policy;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            BatchRead record = this.records.get(this.batchIndex);
            if (Arrays.equals(key.digest, record.key.digest)) {
                if (this.resultCode == 0) {
                    record.record = this.parseRecord();
                }
            } else {
                throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.batchIndex);
            }
        }
    }
}

