/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.Batch;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import java.util.List;

public final class BatchExecutor {
    public static void execute(Cluster cluster, BatchPolicy policy, Key[] keys, boolean[] existsArray, Record[] records, String[] binNames, int readAttr) {
        if (keys.length == 0) {
            return;
        }
        List<BatchNode> batchNodes = BatchNode.generateList(cluster, policy, keys);
        if (policy.maxConcurrentThreads == 1 || batchNodes.size() <= 1) {
            for (BatchNode batchNode : batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    MultiCommand command;
                    if (records != null) {
                        command = new Batch.GetArrayCommand(batchNode, policy, keys, binNames, records, readAttr);
                        command.execute();
                        continue;
                    }
                    command = new Batch.ExistsArrayCommand(batchNode, policy, keys, existsArray);
                    command.execute();
                    continue;
                }
                batchNode.splitByNamespace(keys);
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    MultiCommand command;
                    if (records != null) {
                        command = new Batch.GetArrayDirect(batchNode.node, batchNamespace, policy, keys, binNames, records, readAttr);
                        command.execute();
                        continue;
                    }
                    command = new Batch.ExistsArrayDirect(batchNode.node, batchNamespace, policy, keys, existsArray);
                    command.execute();
                }
            }
        } else {
            Executor executor = new Executor(cluster, batchNodes.size() * 2);
            for (BatchNode batchNode : batchNodes) {
                if (batchNode.node.useNewBatch(policy)) {
                    MultiCommand command;
                    if (records != null) {
                        command = new Batch.GetArrayCommand(batchNode, policy, keys, binNames, records, readAttr);
                        executor.addCommand(command);
                        continue;
                    }
                    command = new Batch.ExistsArrayCommand(batchNode, policy, keys, existsArray);
                    executor.addCommand(command);
                    continue;
                }
                batchNode.splitByNamespace(keys);
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    MultiCommand command;
                    if (records != null) {
                        command = new Batch.GetArrayDirect(batchNode.node, batchNamespace, policy, keys, binNames, records, readAttr);
                        executor.addCommand(command);
                        continue;
                    }
                    command = new Batch.ExistsArrayDirect(batchNode.node, batchNamespace, policy, keys, existsArray);
                    executor.addCommand(command);
                }
            }
            executor.execute(policy.maxConcurrentThreads);
        }
    }
}

