/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class WriteCommand
extends SyncCommand {
    private final Cluster cluster;
    private final WritePolicy policy;
    private final Key key;
    private final Partition partition;
    private final Bin[] bins;
    private final Operation.Type operation;

    public WriteCommand(Cluster cluster, WritePolicy policy, Key key, Bin[] bins, Operation.Type operation) {
        this.cluster = cluster;
        this.policy = policy;
        this.key = key;
        this.partition = new Partition(key);
        this.bins = bins;
        this.operation = operation;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() {
        this.setWrite(this.policy, this.operation, this.key, this.bins);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30);
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
        this.emptySocket(conn);
    }
}

