/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.large;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.util.Util;
import java.util.Map;

public class LargeMap {
    private static final String PackageName = "lmap";
    private final AerospikeClient client;
    private final WritePolicy policy;
    private final Key key;
    private final Value binName;
    private final Value createModule;

    public LargeMap(AerospikeClient client, WritePolicy policy, Key key, String binName, String createModule) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
        this.createModule = Value.get(createModule);
    }

    public void put(Value name, Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "put", this.binName, name, value, this.createModule);
    }

    public void put(Map<?, ?> map) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "put_all", this.binName, Value.get(map), this.createModule);
    }

    public Map<?, ?> get(Value name) throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "get", this.binName, name);
    }

    public boolean exists(Value keyValue) throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "exists", this.binName, keyValue);
        return Util.toBoolean(result);
    }

    public Map<?, ?> scan() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "scan", this.binName);
    }

    public Map<?, ?> filter(String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "filter", this.binName, Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public void remove(Value name) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "remove", this.binName, name, this.createModule);
    }

    public void destroy() throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "destroy", this.binName);
    }

    public int size() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "size", this.binName);
        return Util.toInt(result);
    }

    public Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "config", this.binName);
    }

    public void setCapacity(int capacity) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "set_capacity", this.binName, Value.get(capacity));
    }

    public int getCapacity() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "get_capacity", this.binName);
        return Util.toInt(result);
    }
}

