/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.command.Buffer;
import java.util.Calendar;

public abstract class PredExp {
    private static final int AND = 1;
    private static final int OR = 2;
    private static final int NOT = 3;
    private static final int INTEGER_VALUE = 10;
    private static final int STRING_VALUE = 11;
    private static final int GEOJSON_VALUE = 12;
    private static final int INTEGER_BIN = 100;
    private static final int STRING_BIN = 101;
    private static final int GEOJSON_BIN = 102;
    private static final int LIST_BIN = 103;
    private static final int MAP_BIN = 104;
    private static final int INTEGER_VAR = 120;
    private static final int STRING_VAR = 121;
    private static final int GEOJSON_VAR = 122;
    private static final int RECSIZE = 150;
    private static final int LAST_UPDATE = 151;
    private static final int VOID_TIME = 152;
    private static final int DIGEST_MODULO = 153;
    private static final int INTEGER_EQUAL = 200;
    private static final int INTEGER_UNEQUAL = 201;
    private static final int INTEGER_GREATER = 202;
    private static final int INTEGER_GREATEREQ = 203;
    private static final int INTEGER_LESS = 204;
    private static final int INTEGER_LESSEQ = 205;
    private static final int STRING_EQUAL = 210;
    private static final int STRING_UNEQUAL = 211;
    private static final int STRING_REGEX = 212;
    private static final int GEOJSON_WITHIN = 220;
    private static final int GEOJSON_CONTAINS = 221;
    private static final int LIST_ITERATE_OR = 250;
    private static final int MAPKEY_ITERATE_OR = 251;
    private static final int MAPVAL_ITERATE_OR = 252;
    private static final int LIST_ITERATE_AND = 253;
    private static final int MAPKEY_ITERATE_AND = 254;
    private static final int MAPVAL_ITERATE_AND = 255;
    private static final long NANOS_PER_MILLIS = 1000000L;

    public static PredExp and(int nexp) {
        return new AndOr(1, nexp);
    }

    public static PredExp or(int nexp) {
        return new AndOr(2, nexp);
    }

    public static PredExp not() {
        return new Op(3);
    }

    public static PredExp integerValue(Calendar val) {
        return new IntegerValue(val.getTimeInMillis() * 1000000L, 10);
    }

    public static PredExp integerValue(long val) {
        return new IntegerValue(val, 10);
    }

    public static PredExp stringValue(String val) {
        return new StringValue(val, 11);
    }

    public static PredExp geoJSONValue(String val) {
        return new StringValue(val, 12);
    }

    public static PredExp integerBin(String name) {
        return new StringValue(name, 100);
    }

    public static PredExp stringBin(String name) {
        return new StringValue(name, 101);
    }

    public static PredExp geoJSONBin(String name) {
        return new StringValue(name, 102);
    }

    public static PredExp listBin(String name) {
        return new StringValue(name, 103);
    }

    public static PredExp mapBin(String name) {
        return new StringValue(name, 104);
    }

    public static PredExp integerVar(String name) {
        return new StringValue(name, 120);
    }

    public static PredExp stringVar(String name) {
        return new StringValue(name, 121);
    }

    public static PredExp geoJSONVar(String name) {
        return new StringValue(name, 122);
    }

    public static PredExp recDeviceSize() {
        return new Op(150);
    }

    public static PredExp recLastUpdate() {
        return new Op(151);
    }

    public static PredExp recVoidTime() {
        return new Op(152);
    }

    public static PredExp recDigestModulo(int mod) {
        return new OpInt(153, mod);
    }

    public static PredExp integerEqual() {
        return new Op(200);
    }

    public static PredExp integerUnequal() {
        return new Op(201);
    }

    public static PredExp integerGreater() {
        return new Op(202);
    }

    public static PredExp integerGreaterEq() {
        return new Op(203);
    }

    public static PredExp integerLess() {
        return new Op(204);
    }

    public static PredExp integerLessEq() {
        return new Op(205);
    }

    public static PredExp stringEqual() {
        return new Op(210);
    }

    public static PredExp stringUnequal() {
        return new Op(211);
    }

    public static PredExp stringRegex(int flags) {
        return new OpInt(212, flags);
    }

    public static PredExp geoJSONWithin() {
        return new Op(220);
    }

    public static PredExp geoJSONContains() {
        return new Op(221);
    }

    public static PredExp listIterateOr(String varName) {
        return new StringValue(varName, 250);
    }

    public static PredExp listIterateAnd(String varName) {
        return new StringValue(varName, 253);
    }

    public static PredExp mapKeyIterateOr(String varName) {
        return new StringValue(varName, 251);
    }

    public static PredExp mapKeyIterateAnd(String varName) {
        return new StringValue(varName, 254);
    }

    public static PredExp mapValIterateOr(String varName) {
        return new StringValue(varName, 252);
    }

    public static PredExp mapValIterateAnd(String varName) {
        return new StringValue(varName, 255);
    }

    public static int estimateSize(PredExp[] predExp) {
        int size = 0;
        for (PredExp pred : predExp) {
            size += pred.estimateSize();
        }
        return size;
    }

    public static int write(PredExp[] predExp, byte[] buf, int offset) {
        for (PredExp pred : predExp) {
            offset = pred.write(buf, offset);
        }
        return offset;
    }

    public abstract int estimateSize();

    public abstract int write(byte[] var1, int var2);

    private static class OpInt
    extends PredExp {
        private final int op;
        private final int flags;

        private OpInt(int op, int flags) {
            this.op = op;
            this.flags = flags;
        }

        @Override
        public int estimateSize() {
            return 10;
        }

        @Override
        public int write(byte[] buf, int offset) {
            Buffer.shortToBytes(this.op, buf, offset);
            Buffer.intToBytes(4, buf, offset += 2);
            Buffer.intToBytes(this.flags, buf, offset += 4);
            return offset += 4;
        }
    }

    private static class Op
    extends PredExp {
        private final int op;

        private Op(int op) {
            this.op = op;
        }

        @Override
        public int estimateSize() {
            return 6;
        }

        @Override
        public int write(byte[] buf, int offset) {
            Buffer.shortToBytes(this.op, buf, offset);
            Buffer.intToBytes(0, buf, offset += 2);
            return offset += 4;
        }
    }

    private static class AndOr
    extends PredExp {
        private final int op;
        private final int nexp;

        private AndOr(int op, int nexp) {
            this.op = op;
            this.nexp = nexp;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buf, int offset) {
            Buffer.shortToBytes(this.op, buf, offset);
            Buffer.intToBytes(2, buf, offset += 2);
            Buffer.shortToBytes(this.nexp, buf, offset += 4);
            return offset += 2;
        }
    }

    private static class StringValue
    extends PredExp {
        private final String value;
        private final int type;

        public StringValue(String value, int type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public int estimateSize() {
            return Buffer.estimateSizeUtf8(this.value) + 6;
        }

        @Override
        public int write(byte[] buf, int offset) {
            Buffer.shortToBytes(this.type, buf, offset);
            int len = Buffer.stringToUtf8(this.value, buf, (offset += 2) + 4);
            Buffer.intToBytes(len, buf, offset);
            return offset += 4 + len;
        }
    }

    private static class IntegerValue
    extends PredExp {
        private final long value;
        private final int type;

        private IntegerValue(long value, int type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public int estimateSize() {
            return 14;
        }

        @Override
        public int write(byte[] buf, int offset) {
            Buffer.shortToBytes(this.type, buf, offset);
            Buffer.intToBytes(8, buf, offset += 2);
            Buffer.longToBytes(this.value, buf, offset += 4);
            return offset += 8;
        }
    }
}

