/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import java.io.IOException;

public final class QueryRecordCommand
extends MultiCommand {
    private final Policy policy;
    private final Statement statement;
    private final RecordSet recordSet;

    public QueryRecordCommand(Node node, Policy policy, Statement statement, RecordSet recordSet) {
        super(node, true);
        this.policy = policy;
        this.statement = statement;
        this.recordSet = recordSet;
    }

    @Override
    protected final Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected final void writeBuffer() throws AerospikeException {
        this.setQuery(this.policy, this.statement, false);
    }

    @Override
    protected void parseRow(Key key) throws IOException {
        Record record = this.parseRecord();
        if (!this.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.recordSet.put(new KeyRecord(key, record))) {
            this.stop();
            throw new AerospikeException.QueryTerminated();
        }
    }
}

