/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;

public abstract class Task {
    protected final Cluster cluster;
    protected InfoPolicy policy;
    private boolean done;

    public Task(Cluster cluster, Policy policy) {
        this.cluster = cluster;
        this.policy = new InfoPolicy(policy);
        this.done = false;
    }

    public Task() {
        this.cluster = null;
        this.policy = null;
        this.done = true;
    }

    public final void waitTillComplete() {
        this.taskWait(1000);
    }

    public final void waitTillComplete(int sleepInterval) {
        this.taskWait(sleepInterval);
    }

    public final void waitTillComplete(int sleepInterval, int timeout) {
        this.policy = new InfoPolicy();
        this.policy.timeout = timeout;
        this.taskWait(sleepInterval);
    }

    private final void taskWait(int sleepInterval) {
        long deadline = 0L;
        RuntimeException exception = null;
        while (!this.done) {
            if (deadline == 0L) {
                deadline = System.currentTimeMillis() + (long)this.policy.timeout;
            } else if (this.policy.timeout != 0 && System.currentTimeMillis() + (long)sleepInterval > deadline) {
                if (exception != null) {
                    throw exception;
                }
                throw new AerospikeException.Timeout();
            }
            Util.sleep(sleepInterval);
            try {
                this.done = this.queryIfDone();
            }
            catch (DoneException de) {
                throw de;
            }
            catch (RuntimeException re) {
                exception = re;
            }
        }
    }

    public final boolean isDone() {
        if (this.done) {
            return true;
        }
        this.done = this.queryIfDone();
        return this.done;
    }

    protected abstract boolean queryIfDone();

    public static class DoneException
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public DoneException(String message) {
            super(message);
        }
    }
}

