/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Language;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.Value;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.admin.Privilege;
import com.aerospike.client.admin.Role;
import com.aerospike.client.admin.User;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.AsyncDelete;
import com.aerospike.client.async.AsyncExecute;
import com.aerospike.client.async.AsyncExists;
import com.aerospike.client.async.AsyncOperate;
import com.aerospike.client.async.AsyncQueryExecutor;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.async.AsyncReadHeader;
import com.aerospike.client.async.AsyncScanExecutor;
import com.aerospike.client.async.AsyncTouch;
import com.aerospike.client.async.AsyncWrite;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Batch;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.DeleteCommand;
import com.aerospike.client.command.ExecuteCommand;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.ExistsCommand;
import com.aerospike.client.command.OperateCommand;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.command.ReadHeaderCommand;
import com.aerospike.client.command.RegisterCommand;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.command.TouchCommand;
import com.aerospike.client.command.WriteCommand;
import com.aerospike.client.large.LargeList;
import com.aerospike.client.large.LargeMap;
import com.aerospike.client.large.LargeSet;
import com.aerospike.client.large.LargeStack;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.QueryAggregateExecutor;
import com.aerospike.client.query.QueryRecordExecutor;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.ServerCommand;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.ExecuteTask;
import com.aerospike.client.task.IndexTask;
import com.aerospike.client.task.RegisterTask;
import com.aerospike.client.util.RandomShift;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class AerospikeClient
implements IAerospikeClient,
Closeable {
    protected Cluster cluster;
    public final Policy readPolicyDefault;
    public final WritePolicy writePolicyDefault;
    public final ScanPolicy scanPolicyDefault;
    public final QueryPolicy queryPolicyDefault;
    public final BatchPolicy batchPolicyDefault;
    public final InfoPolicy infoPolicyDefault;

    public AerospikeClient(String hostname, int port) throws AerospikeException {
        this(new ClientPolicy(), new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, Host ... hosts) throws AerospikeException {
        if (policy == null) {
            policy = new ClientPolicy();
        }
        this.readPolicyDefault = policy.readPolicyDefault;
        this.writePolicyDefault = policy.writePolicyDefault;
        this.scanPolicyDefault = policy.scanPolicyDefault;
        this.queryPolicyDefault = policy.queryPolicyDefault;
        this.batchPolicyDefault = policy.batchPolicyDefault;
        this.infoPolicyDefault = policy.infoPolicyDefault;
        this.cluster = new Cluster(policy, hosts);
        this.cluster.initTendThread(policy.failIfNotConnected);
    }

    protected AerospikeClient(ClientPolicy policy) {
        if (policy != null) {
            this.readPolicyDefault = policy.readPolicyDefault;
            this.writePolicyDefault = policy.writePolicyDefault;
            this.scanPolicyDefault = policy.scanPolicyDefault;
            this.queryPolicyDefault = policy.queryPolicyDefault;
            this.batchPolicyDefault = policy.batchPolicyDefault;
            this.infoPolicyDefault = policy.infoPolicyDefault;
        } else {
            this.readPolicyDefault = new Policy();
            this.writePolicyDefault = new WritePolicy();
            this.scanPolicyDefault = new ScanPolicy();
            this.queryPolicyDefault = new QueryPolicy();
            this.batchPolicyDefault = new BatchPolicy();
            this.infoPolicyDefault = new InfoPolicy();
        }
    }

    @Override
    public final Policy getReadPolicyDefault() {
        return this.readPolicyDefault;
    }

    @Override
    public final WritePolicy getWritePolicyDefault() {
        return this.writePolicyDefault;
    }

    @Override
    public final ScanPolicy getScanPolicyDefault() {
        return this.scanPolicyDefault;
    }

    @Override
    public final QueryPolicy getQueryPolicyDefault() {
        return this.queryPolicyDefault;
    }

    @Override
    public final BatchPolicy getBatchPolicyDefault() {
        return this.batchPolicyDefault;
    }

    @Override
    public final InfoPolicy getInfoPolicyDefault() {
        return this.infoPolicyDefault;
    }

    @Override
    public void close() {
        this.cluster.close();
    }

    @Override
    public final boolean isConnected() {
        return this.cluster.isConnected();
    }

    @Override
    public final Node[] getNodes() {
        return this.cluster.getNodes();
    }

    @Override
    public final List<String> getNodeNames() {
        Node[] nodes = this.cluster.getNodes();
        ArrayList<String> names = new ArrayList<String>(nodes.length);
        for (Node node : nodes) {
            names.add(node.getName());
        }
        return names;
    }

    @Override
    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        return this.cluster.getNode(nodeName);
    }

    @Override
    public final void put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(policy, key, bins, Operation.Type.WRITE);
        command.execute(this.cluster, policy, key, null, false);
    }

    @Override
    public final void put(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(listener, policy, key, bins, Operation.Type.WRITE);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(policy, key, bins, Operation.Type.APPEND);
        command.execute(this.cluster, policy, key, null, false);
    }

    @Override
    public final void append(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(listener, policy, key, bins, Operation.Type.APPEND);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(policy, key, bins, Operation.Type.PREPEND);
        command.execute(this.cluster, policy, key, null, false);
    }

    @Override
    public final void prepend(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(listener, policy, key, bins, Operation.Type.PREPEND);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(policy, key, bins, Operation.Type.ADD);
        command.execute(this.cluster, policy, key, null, false);
    }

    @Override
    public final void add(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(listener, policy, key, bins, Operation.Type.ADD);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean delete(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        DeleteCommand command = new DeleteCommand(policy, key);
        command.execute(this.cluster, policy, key, null, false);
        return command.existed();
    }

    @Override
    public final void delete(EventLoop eventLoop, DeleteListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncDelete command = new AsyncDelete(listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void truncate(InfoPolicy policy, String ns, String set, Calendar beforeLastUpdate) throws AerospikeException {
        Node node;
        String response;
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("truncate:namespace=");
        sb.append(ns);
        if (set != null && set.length() > 0) {
            sb.append(";set=");
            sb.append(set);
        }
        if (beforeLastUpdate != null) {
            sb.append(";lut=");
            sb.append(beforeLastUpdate.getTimeInMillis() * 1000000L);
        }
        if (!(response = Info.request(policy, node = this.cluster.getRandomNode(), sb.toString())).equalsIgnoreCase("ok")) {
            throw new AerospikeException("Truncate failed: " + response);
        }
    }

    @Override
    public final void touch(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        TouchCommand command = new TouchCommand(policy, key);
        command.execute(this.cluster, policy, key, null, false);
    }

    @Override
    public final void touch(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncTouch command = new AsyncTouch(listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean exists(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ExistsCommand command = new ExistsCommand(policy, key);
        command.execute(this.cluster, policy, key, null, true);
        return command.exists();
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsListener listener, Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncExists command = new AsyncExists(listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean[] exists(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        boolean[] existsArray = new boolean[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, existsArray, null, null, 33);
        return existsArray;
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new boolean[0]);
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ExistsArrayExecutor(eventLoop, this.cluster, policy, keys, listener);
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ExistsSequenceExecutor(eventLoop, this.cluster, policy, keys, listener);
    }

    @Override
    public final Record get(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadCommand command = new ReadCommand(policy, key, null);
        command.execute(this.cluster, policy, key, null, true);
        return command.getRecord();
    }

    @Override
    public final void get(EventLoop eventLoop, RecordListener listener, Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncRead command = new AsyncRead(listener, policy, key, null, true);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final Record get(Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadCommand command = new ReadCommand(policy, key, binNames);
        command.execute(this.cluster, policy, key, null, true);
        return command.getRecord();
    }

    @Override
    public final void get(EventLoop eventLoop, RecordListener listener, Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncRead command = new AsyncRead(listener, policy, key, binNames, true);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final Record getHeader(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadHeaderCommand command = new ReadHeaderCommand(policy, key);
        command.execute(this.cluster, policy, key, null, true);
        return command.getRecord();
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordListener listener, Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        AsyncReadHeader command = new AsyncReadHeader(listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void get(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        List<BatchNode> batchNodes = BatchNode.generateList(this.cluster, policy, records);
        if (policy.maxConcurrentThreads == 1 || batchNodes.size() <= 1) {
            for (BatchNode batchNode : batchNodes) {
                if (!batchNode.node.hasBatchIndex()) {
                    throw new AerospikeException(4, "Requested command requires a server that supports new batch index protocol.");
                }
                Batch.ReadListCommand command = new Batch.ReadListCommand(batchNode, policy, records);
                command.execute(this.cluster, policy, null, batchNode.node, true);
            }
        } else {
            Executor executor = new Executor(this.cluster, policy, batchNodes.size());
            for (BatchNode batchNode : batchNodes) {
                if (!batchNode.node.hasBatchIndex()) {
                    throw new AerospikeException(4, "Requested command requires a server that supports new batch index protocol.");
                }
                Batch.ReadListCommand command = new Batch.ReadListCommand(batchNode, policy, records);
                executor.addCommand(batchNode.node, command);
            }
            executor.execute(policy.maxConcurrentThreads);
        }
    }

    @Override
    public final void get(EventLoop eventLoop, BatchListListener listener, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess(records);
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ReadListExecutor(eventLoop, this.cluster, policy, listener, records);
    }

    @Override
    public final void get(EventLoop eventLoop, BatchSequenceListener listener, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess();
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.ReadSequenceExecutor(eventLoop, this.cluster, policy, listener, records);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, null, 3);
        return records;
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, null, 3);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, null, 3);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, binNames, 1);
        return records;
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, binNames, 1);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, binNames, 1);
    }

    @Override
    public final Record[] getHeader(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys.length];
        BatchExecutor.execute(this.cluster, policy, keys, null, records, null, 33);
        return records;
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetArrayExecutor(eventLoop, this.cluster, policy, listener, keys, null, 33);
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        new AsyncBatch.GetSequenceExecutor(eventLoop, this.cluster, policy, listener, keys, null, 33);
    }

    @Override
    public final Record operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        OperateCommand command = new OperateCommand(policy, key, operations);
        command.execute(this.cluster, policy, key, null, false);
        return command.getRecord();
    }

    @Override
    public final void operate(EventLoop eventLoop, RecordListener listener, WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncOperate command = new AsyncOperate(listener, policy, key, operations);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void scanAll(ScanPolicy policy, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        if (policy.scanPercent <= 0 || policy.scanPercent > 100) {
            throw new AerospikeException(4, "Invalid scan percent: " + policy.scanPercent);
        }
        Node[] nodes = this.cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Scan failed because cluster is empty.");
        }
        if (policy.concurrentNodes) {
            Executor executor = new Executor(this.cluster, policy, nodes.length);
            long taskId = RandomShift.instance().nextLong();
            for (Node node : nodes) {
                ScanCommand command = new ScanCommand(policy, namespace, setName, callback, binNames, taskId);
                executor.addCommand(node, command);
            }
            executor.execute(policy.maxConcurrentNodes);
        } else {
            for (Node node : nodes) {
                this.scanNode(policy, node, namespace, setName, callback, binNames);
            }
        }
    }

    @Override
    public final void scanAll(EventLoop eventLoop, RecordSequenceListener listener, ScanPolicy policy, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        new AsyncScanExecutor(eventLoop, this.cluster, policy, listener, namespace, setName, binNames);
    }

    @Override
    public final void scanNode(ScanPolicy policy, String nodeName, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        Node node = this.cluster.getNode(nodeName);
        this.scanNode(policy, node, namespace, setName, callback, binNames);
    }

    @Override
    public final void scanNode(ScanPolicy policy, Node node, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        if (policy.scanPercent <= 0 || policy.scanPercent > 100) {
            throw new AerospikeException(4, "Invalid scan percent: " + policy.scanPercent);
        }
        long taskId = RandomShift.instance().nextLong();
        ScanCommand command = new ScanCommand(policy, namespace, setName, callback, binNames, taskId);
        command.execute(this.cluster, policy, null, node, true);
    }

    @Override
    public final LargeList getLargeList(WritePolicy policy, Key key, String binName) {
        return new LargeList(this, policy, key, binName);
    }

    @Override
    public final LargeMap getLargeMap(WritePolicy policy, Key key, String binName, String userModule) {
        return new LargeMap(this, policy, key, binName, userModule);
    }

    @Override
    public final LargeSet getLargeSet(WritePolicy policy, Key key, String binName, String userModule) {
        return new LargeSet(this, policy, key, binName, userModule);
    }

    @Override
    public final LargeStack getLargeStack(WritePolicy policy, Key key, String binName, String userModule) {
        return new LargeStack(this, policy, key, binName, userModule);
    }

    @Override
    public final RegisterTask register(Policy policy, String clientPath, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        File file = new File(clientPath);
        byte[] bytes = Util.readFile(file);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final RegisterTask register(Policy policy, ClassLoader resourceLoader, String resourcePath, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        byte[] bytes = Util.readResource(resourceLoader, resourcePath);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final RegisterTask registerUdfString(Policy policy, String code, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        byte[] bytes = Buffer.stringToUtf8(code);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final void removeUdf(InfoPolicy policy, String serverPath) throws AerospikeException {
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        String command = "udf-remove:filename=" + serverPath;
        Node node = this.cluster.getRandomNode();
        String response = Info.request(policy, node, command);
        if (response.equalsIgnoreCase("ok")) {
            return;
        }
        if (response.startsWith("error=file_not_found")) {
            return;
        }
        throw new AerospikeException("Remove UDF failed: " + response);
    }

    @Override
    public final Object execute(WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        ExecuteCommand command = new ExecuteCommand(policy, key, packageName, functionName, functionArgs);
        command.execute(this.cluster, policy, key, null, false);
        Record record = command.getRecord();
        if (record == null || record.bins == null) {
            return null;
        }
        Map<String, Object> map = record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }

    @Override
    public final void execute(EventLoop eventLoop, ExecuteListener listener, WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncExecute command = new AsyncExecute(listener, policy, key, packageName, functionName, functionArgs);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final ExecuteTask execute(WritePolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        statement.prepare(false);
        Node[] nodes = this.cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Command failed because cluster is empty.");
        }
        Executor executor = new Executor(this.cluster, policy, nodes.length);
        for (Node node : nodes) {
            ServerCommand command = new ServerCommand(policy, statement);
            executor.addCommand(node, command);
        }
        executor.execute(nodes.length);
        return new ExecuteTask(this.cluster, policy, statement);
    }

    @Override
    public final RecordSet query(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, null);
        executor.execute();
        return executor.getRecordSet();
    }

    @Override
    public final void query(EventLoop eventLoop, RecordSequenceListener listener, QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        new AsyncQueryExecutor(eventLoop, listener, this.cluster, policy, statement);
    }

    @Override
    public final RecordSet queryNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, node);
        executor.execute();
        return executor.getRecordSet();
    }

    @Override
    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        return this.queryAggregate(policy, statement);
    }

    @Override
    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        statement.prepare(true);
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, null);
        return executor.getResultSet();
    }

    @Override
    public final ResultSet queryAggregateNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        statement.prepare(true);
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, node);
        return executor.getResultSet();
    }

    @Override
    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType) throws AerospikeException {
        return this.createIndex(policy, namespace, setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-create:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        sb.append(";numbins=1");
        if (indexCollectionType != IndexCollectionType.DEFAULT) {
            sb.append(";indextype=");
            sb.append((Object)indexCollectionType);
        }
        sb.append(";indexdata=");
        sb.append(binName);
        sb.append(",");
        sb.append((Object)indexType);
        sb.append(";priority=normal");
        String response = this.sendInfoCommand(policy, sb.toString());
        if (response.equalsIgnoreCase("OK")) {
            return new IndexTask(this.cluster, policy, namespace, indexName);
        }
        if (response.startsWith("FAIL:200")) {
            return new IndexTask();
        }
        throw new AerospikeException("Create index failed: " + response);
    }

    @Override
    public final void dropIndex(Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-delete:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        String response = this.sendInfoCommand(policy, sb.toString());
        if (response.equalsIgnoreCase("OK")) {
            return;
        }
        if (response.startsWith("FAIL:201")) {
            return;
        }
        throw new AerospikeException("Drop index failed: " + response);
    }

    @Override
    public final void createUser(AdminPolicy policy, String user, String password, List<String> roles) throws AerospikeException {
        String hash = AdminCommand.hashPassword(password);
        AdminCommand command = new AdminCommand();
        command.createUser(this.cluster, policy, user, hash, roles);
    }

    @Override
    public final void dropUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropUser(this.cluster, policy, user);
    }

    @Override
    public final void changePassword(AdminPolicy policy, String user, String password) throws AerospikeException {
        if (this.cluster.getUser() == null) {
            throw new AerospikeException("Invalid user");
        }
        String hash = AdminCommand.hashPassword(password);
        AdminCommand command = new AdminCommand();
        byte[] userBytes = Buffer.stringToUtf8(user);
        if (Arrays.equals(userBytes, this.cluster.getUser())) {
            command.changePassword(this.cluster, policy, userBytes, hash);
        } else {
            command.setPassword(this.cluster, policy, userBytes, hash);
        }
        this.cluster.changePassword(userBytes, hash);
    }

    @Override
    public final void grantRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantRoles(this.cluster, policy, user, roles);
    }

    @Override
    public final void revokeRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokeRoles(this.cluster, policy, user, roles);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void dropRole(AdminPolicy policy, String roleName) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropRole(this.cluster, policy, roleName);
    }

    @Override
    public final void grantPrivileges(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantPrivileges(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void revokePrivileges(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokePrivileges(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final User queryUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand.UserCommand command = new AdminCommand.UserCommand(1);
        return command.queryUser(this.cluster, policy, user);
    }

    @Override
    public final List<User> queryUsers(AdminPolicy policy) throws AerospikeException {
        AdminCommand.UserCommand command = new AdminCommand.UserCommand(100);
        return command.queryUsers(this.cluster, policy);
    }

    @Override
    public final Role queryRole(AdminPolicy policy, String roleName) throws AerospikeException {
        AdminCommand.RoleCommand command = new AdminCommand.RoleCommand(1);
        return command.queryRole(this.cluster, policy, roleName);
    }

    @Override
    public final List<Role> queryRoles(AdminPolicy policy) throws AerospikeException {
        AdminCommand.RoleCommand command = new AdminCommand.RoleCommand(100);
        return command.queryRoles(this.cluster, policy);
    }

    private String sendInfoCommand(Policy policy, String command) throws AerospikeException {
        Info info;
        Node node = this.cluster.getRandomNode();
        Connection conn = node.getConnection(policy.socketTimeout);
        try {
            info = new Info(conn, command);
            node.putConnection(conn);
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
        return info.getValue();
    }
}

