/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.async.AsyncConnection;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.nio.ByteBuffer;

public final class NettyConnection
implements AsyncConnection {
    final NioSocketChannel channel;
    private final long maxSocketIdle;
    private long lastUsed;

    public NettyConnection(NioSocketChannel channel, long maxSocketIdle) {
        this.channel = channel;
        this.maxSocketIdle = maxSocketIdle;
    }

    @Override
    public boolean isValid(ByteBuffer notUsed) {
        return System.nanoTime() - this.lastUsed <= this.maxSocketIdle && this.channel.isActive();
    }

    void updateLastUsed() {
        this.lastUsed = System.nanoTime();
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

