/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NioCommand;
import com.aerospike.client.async.ScheduleTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioEventLoop
extends Thread
implements EventLoop {
    final ConcurrentLinkedDeque<Runnable> commandQueue;
    final ArrayDeque<ScheduleTask> scheduleQueue;
    final ArrayDeque<ByteBuffer> byteBufferQueue;
    final ArrayDeque<byte[]> bufferQueue;
    final HashedWheelTimer timer;
    final Selector selector;
    final AtomicBoolean awakened = new AtomicBoolean();
    final long selectorTimeout;
    final int index;
    int errors;

    public NioEventLoop(EventPolicy policy, SelectorProvider provider, int index2) throws IOException {
        this.commandQueue = new ConcurrentLinkedDeque();
        this.scheduleQueue = new ArrayDeque(8);
        this.byteBufferQueue = new ArrayDeque(policy.commandsPerEventLoop);
        this.bufferQueue = new ArrayDeque(policy.commandsPerEventLoop);
        this.timer = new HashedWheelTimer(this, policy.minTimeout, TimeUnit.MILLISECONDS, policy.ticksPerWheel);
        this.selectorTimeout = policy.minTimeout;
        this.selector = provider.openSelector();
        this.index = index2;
    }

    @Override
    public void execute(Cluster cluster, AsyncCommand command) {
        new NioCommand(this, cluster, command);
    }

    @Override
    public void execute(Runnable command) {
        this.commandQueue.offerLast(command);
        if (this.awakened.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    @Override
    public void schedule(Runnable command, long delay, TimeUnit unit) {
        final ScheduleTask task = new ScheduleTask(command, delay, unit);
        if (this == Thread.currentThread()) {
            this.scheduleQueue.offer(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioEventLoop.this.scheduleQueue.offer(task);
                }
            });
        }
    }

    @Override
    public void schedule(final ScheduleTask task, long delay, TimeUnit unit) {
        task.setDeadline(delay, unit);
        if (this == Thread.currentThread()) {
            this.scheduleQueue.offer(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioEventLoop.this.scheduleQueue.offer(task);
                }
            });
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public EventState createState() {
        return new EventState(this, this.index);
    }

    public static ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size + 8191 & 0xFFFFE000);
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = this.byteBufferQueue.pollFirst();
        if (byteBuffer == null) {
            byteBuffer = NioEventLoop.createByteBuffer(8192);
        }
        return byteBuffer;
    }

    public void putByteBuffer(ByteBuffer byteBuffer) {
        this.byteBufferQueue.addLast(byteBuffer);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.runCommands();
                }
            }
            catch (CloseException ce) {
            }
            catch (Exception e) {
                if (Log.warnEnabled()) {
                    Log.warn("Event loop error: " + Util.getErrorMessage(e));
                }
                Util.sleep(100L);
                continue;
            }
            break;
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommands() throws Exception {
        Set<SelectionKey> keys;
        this.registerCommands();
        this.runScheduled();
        this.awakened.set(false);
        this.selector.select(this.selectorTimeout);
        if (this.awakened.get()) {
            this.selector.wakeup();
        }
        if ((keys = this.selector.selectedKeys()).isEmpty()) {
            return;
        }
        try {
            for (SelectionKey key : keys) {
                if (!key.isValid()) continue;
                this.processKey(key);
            }
        }
        finally {
            keys.clear();
        }
    }

    private void registerCommands() {
        Runnable command;
        Runnable last = this.commandQueue.peekLast();
        while ((command = this.commandQueue.pollFirst()) != null) {
            command.run();
            if (command != last) continue;
            break;
        }
    }

    private void runScheduled() {
        ScheduleTask command;
        ScheduleTask last = this.scheduleQueue.peekLast();
        long currentTime = System.nanoTime();
        while ((command = this.scheduleQueue.pollFirst()) != null) {
            if (command.deadline <= currentTime) {
                command.run();
                currentTime = System.nanoTime();
            } else {
                this.scheduleQueue.addLast(command);
            }
            if (command != last) continue;
            break;
        }
    }

    private void processKey(SelectionKey key) {
        NioCommand command = (NioCommand)key.attachment();
        try {
            int ops = key.readyOps();
            if ((ops & 1) != 0) {
                command.read();
            } else if ((ops & 4) != 0) {
                command.write();
            } else if ((ops & 8) != 0) {
                command.finishConnect();
            }
        }
        catch (AerospikeException.Connection ac) {
            command.onNetworkError(ac);
        }
        catch (AerospikeException ae) {
            if (ae.getResultCode() == 9) {
                command.onServerTimeout();
            } else {
                command.onApplicationError(ae);
            }
        }
        catch (IOException ioe) {
            command.onNetworkError(new AerospikeException(ioe));
        }
        catch (Exception e) {
            command.onApplicationError(new AerospikeException(e));
        }
    }

    public void close() {
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class CloseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CloseException() {
        }
    }
}

